/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.apms.plugin.utils;

import com.huawei.agconnect.apms.plugin.APMSGradlePlugin;
import com.huawei.agconnect.apms.plugin.utils.NamespaceContextImpl;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.gradle.api.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlReader {
    private static final Logger logger = APMSGradlePlugin.getLogger();
    private XPath xPath;
    private Document document;

    public XmlReader(File file) {
        try {
            File newFile = File.createTempFile("new_android_manifest", null, null);
            newFile.deleteOnExit();
            this.copyFile(file.getCanonicalPath(), newFile.getCanonicalPath());
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(newFile);
            this.xPath = XPathFactory.newInstance().newXPath();
            this.xPath.setNamespaceContext(new NamespaceContextImpl());
        }
        catch (Throwable ex) {
            logger.warn("fail to read manifest file: " + ex.getMessage());
        }
    }

    public String getApplicationSelfName() {
        try {
            Node node = (Node)this.xPath.evaluate("/manifest/application", this.document, XPathConstants.NODE);
            return node.getAttributes().getNamedItem("android:name") != null ? node.getAttributes().getNamedItem("android:name").getNodeValue() : "";
        }
        catch (Exception ex) {
            logger.warn("fail to get application name: " + ex.getMessage());
            return "";
        }
    }

    public String getApplicationPackageName() {
        try {
            Node node = (Node)this.xPath.evaluate("/manifest", this.document, XPathConstants.NODE);
            return node.getAttributes().getNamedItem("package") != null ? node.getAttributes().getNamedItem("package").getNodeValue() : "";
        }
        catch (Exception ex) {
            logger.warn("fail to get package name: " + ex.getMessage());
            return "";
        }
    }

    public Set<String> getActivityLists() {
        try {
            HashSet<String> activityNames = new HashSet<String>();
            NodeList list = (NodeList)this.xPath.evaluate("/manifest/application/activity", this.document, XPathConstants.NODESET);
            for (int i = 0; i < list.getLength(); ++i) {
                Node item = list.item(i);
                NamedNodeMap attributes = item.getAttributes();
                String nodeValue = null;
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Node item2 = attributes.item(j);
                    if (!item2.getNodeName().equals("android:name")) continue;
                    nodeValue = item2.getNodeValue();
                    break;
                }
                activityNames.add(nodeValue);
            }
            return activityNames;
        }
        catch (Exception ex) {
            logger.warn("fail to get activity lists: " + ex.getMessage());
            return new HashSet<String>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String oldFilePath, String newFilePath) {
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            String str;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(oldFilePath), StandardCharsets.UTF_8));
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newFilePath), StandardCharsets.UTF_8));
            boolean num = true;
            while ((str = bufferedReader.readLine()) != null) {
                if (num) {
                    str = this.replace(str);
                    num = false;
                }
                bufferedWriter.write(str + System.getProperty("line.separator"));
                bufferedWriter.flush();
            }
        }
        catch (IOException ex) {
            logger.warn("can not find manifest file: " + ex.getMessage());
        }
        finally {
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                }
                catch (Exception ex) {
                    logger.warn("fail to close bufferedReader: " + ex.getMessage());
                }
            }
            if (null != bufferedWriter) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception ex) {
                    logger.warn("fail to close bufferedWriter: " + ex.getMessage());
                }
            }
        }
    }

    private String replace(String substring) {
        if (substring.startsWith("\ufeff")) {
            substring = substring.substring(1);
        }
        return substring;
    }
}

