/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.https;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.huawei.agconnect.crash.symbol.lib.log.AGCLogger;
import com.huawei.agconnect.https.FileRequest;
import com.huawei.agconnect.https.Request;
import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public class Backend {
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String CONTENT_FORM_DATA_BOUNDARY = "multipart/form-data;boundary=";
    private static final int CONNECT_TIMEOUT = 10000;
    private static final String FILE_LARGE_ERROR = "Uploading failed because the mapping file is too large, please upload it manually on the AGC website or contact the webmaster";

    public static <T> T postJson(Request request, Class<T> clazz) {
        return Backend.postJson(request, clazz, 0);
    }

    private static <T> T postJson(Request request, Class<T> clazz, int index) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getParams().setParameter("http.connection.timeout", (Object)10000);
        HttpPost httpPost = new HttpPost();
        httpPost.setURI(URI.create(request.getUrls().get(index++)));
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            httpPost.addHeader(entry.getKey(), entry.getValue());
        }
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        String json = gson.toJson((Object)request);
        try {
            StringEntity entity = new StringEntity(json, "utf-8");
            entity.setContentType(CONTENT_TYPE_JSON);
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int code = response.getStatusLine().getStatusCode();
            HttpEntity httpEntity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)httpEntity);
            if (code == 200) {
                return (T)new Gson().fromJson(result, clazz);
            }
            AGCLogger.error((String)String.format("ERROR:HTTP Exception, code:%s, response:%s", code, result));
        }
        catch (IOException e) {
            if (e instanceof UnknownHostException && request.getUrls().size() > index) {
                return Backend.postJson(request, clazz, index);
            }
            AGCLogger.error((String)("ERROR:HTTP Exception, " + e.getMessage()));
        }
        return null;
    }

    public static <T> T postFile(FileRequest request, Class<T> clazz) {
        return Backend.postFile(request, clazz, 0);
    }

    private static <T> T postFile(FileRequest request, Class<T> clazz, int index) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getParams().setParameter("http.connection.timeout", (Object)10000);
        HttpPost httpPost = new HttpPost();
        httpPost.setURI(URI.create(request.getUrls().get(index++)));
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            httpPost.addHeader(entry.getKey(), entry.getValue());
        }
        String boundary = UUID.randomUUID().toString();
        httpPost.addHeader("Content-Type", CONTENT_FORM_DATA_BOUNDARY + boundary);
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.STRICT, boundary, Charset.forName("UTF-8"));
        FileBody fileBody = new FileBody(request.getFile());
        entity.addPart("file", (ContentBody)fileBody);
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        String json = gson.toJson((Object)request);
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        try {
            if (element.isJsonObject()) {
                Set entrySet = element.getAsJsonObject().entrySet();
                for (Map.Entry entry : entrySet) {
                    entity.addPart((String)entry.getKey(), (ContentBody)new StringBody(((JsonElement)entry.getValue()).getAsString()));
                }
            }
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int code = response.getStatusLine().getStatusCode();
            HttpEntity httpEntity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)httpEntity);
            if (code == 200) {
                return (T)new Gson().fromJson(result, clazz);
            }
            if (code == 413) {
                AGCLogger.error((String)String.format("ERROR:HTTP Exception, code:%s, response:%s", code, FILE_LARGE_ERROR));
            } else {
                AGCLogger.error((String)String.format("ERROR:HTTP Exception, code:%s, response:%s", code, result));
            }
        }
        catch (Exception e) {
            if (e instanceof UnknownHostException && request.getUrls().size() > index) {
                return Backend.postFile(request, clazz, index);
            }
            AGCLogger.error((String)("ERROR:HTTP Exception, " + e.getMessage()));
        }
        return null;
    }
}

