/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.agcp;

import com.huawei.agconnect.crash.symbol.lib.log.AGCLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private static final int BUFFER_SIZE = 2048;

    public static void zip(File inFile, File outFile) {
        ZipUtils.delete(outFile);
        try {
            int len;
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outFile), 2048);
            ZipOutputStream zos = new ZipOutputStream(bos);
            ZipEntry entry = new ZipEntry(inFile.getName());
            zos.putNextEntry(entry);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(inFile));
            byte[] buffer = new byte[2048];
            while ((len = bis.read(buffer)) != -1) {
                zos.write(buffer, 0, len);
            }
            bis.close();
            zos.closeEntry();
            zos.close();
            bos.close();
        }
        catch (IOException e) {
            AGCLogger.error((String)("ERROR:IOException when zip file" + e.getMessage()));
        }
    }

    public static File zipFile(List<File> inFiles, String outDir, String outName) {
        if (inFiles == null || inFiles.size() == 0) {
            return null;
        }
        File outFile = new File(outDir, outName);
        ZipUtils.delete(outFile);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outFile), 2048);
            ZipOutputStream zos = new ZipOutputStream(bos);
            for (File f : inFiles) {
                int len;
                ZipEntry entry = new ZipEntry(f.getName());
                zos.putNextEntry(entry);
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
                byte[] buffer = new byte[2048];
                while ((len = bis.read(buffer)) != -1) {
                    zos.write(buffer, 0, len);
                }
                bis.close();
            }
            zos.closeEntry();
            zos.close();
            bos.close();
            return outFile;
        }
        catch (IOException e) {
            AGCLogger.error((String)"ERROR: compress symbol file error");
            return null;
        }
    }

    private static void delete(File file) {
        if (file != null && file.exists() && !file.delete()) {
            AGCLogger.error((String)"ERROR: delete file error");
        }
    }
}

