/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.agcp;

import com.huawei.agconnect.agcp.AGCPSecureRandom;
import com.huawei.agconnect.agcp.AesParam;
import com.huawei.agconnect.agcp.Keys;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class EncryptLocalResource {
    private SecretKey secretKey;

    public EncryptLocalResource(AesParam aesParam) {
        try {
            this.secretKey = Keys.buildAesKey(aesParam);
        }
        catch (IllegalArgumentException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            this.secretKey = null;
        }
    }

    public byte[] encrypt(byte[] text) throws GeneralSecurityException {
        if (this.secretKey == null) {
            return text;
        }
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec encryptIv = new IvParameterSpec(AGCPSecureRandom.getInstance().getRandom(16));
        cipher.init(1, (Key)this.secretKey, encryptIv);
        byte[] cipherText = cipher.doFinal(text);
        byte[] iv = cipher.getIV();
        if (iv == null) {
            throw new GeneralSecurityException("Fail to receive IV.");
        }
        byte[] cipherTextWithIV = new byte[1 + iv.length + cipherText.length];
        cipherTextWithIV[0] = 0;
        System.arraycopy(iv, 0, cipherTextWithIV, 1, iv.length);
        System.arraycopy(cipherText, 0, cipherTextWithIV, iv.length + 1, cipherText.length);
        return cipherTextWithIV;
    }
}

