/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.apms.plugin.instrument.visitor;

import com.huawei.agconnect.apms.plugin.APMSGradlePlugin;
import com.huawei.agconnect.apms.plugin.instrument.InstrumentationContext;
import com.huawei.agconnect.apms.plugin.instrument.model.ClassMethod;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.gradle.api.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.GeneratorAdapter;

public class CallReplacementVisitor
extends ClassVisitor {
    private final InstrumentationContext context;
    private static final Logger logger = APMSGradlePlugin.getLogger();
    private static final HashSet<String> INCLUDE_PACKAGES = new HashSet<String>(){
        {
            this.add("com/huawei/agconnect/cloud/storage/internal/common/utils");
        }
    };

    public CallReplacementVisitor(ClassVisitor cv, InstrumentationContext context) {
        super(458752, cv);
        this.context = context;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String sig, String[] exceptions) {
        if (this.context.isSkippedMethod(name, desc)) {
            return super.visitMethod(access, name, desc, sig, exceptions);
        }
        return new CallMethodReplacementVisitor(super.visitMethod(access, name, desc, sig, exceptions), access, name, desc, this.context);
    }

    private static class CallMethodReplacementVisitor
    extends GeneratorAdapter {
        private String name;
        private String desc;
        private InstrumentationContext context;

        CallMethodReplacementVisitor(MethodVisitor mv, int access, String name, String desc, InstrumentationContext context) {
            super(458752, mv, access, name, desc);
            this.name = name;
            this.desc = desc;
            this.context = context;
        }

        private boolean isIncludedPackage(String packageName) {
            String lowercasePackageName = packageName.toLowerCase(Locale.ENGLISH);
            for (String validPackageName : INCLUDE_PACKAGES) {
                if (!lowercasePackageName.startsWith(validPackageName)) continue;
                return true;
            }
            return false;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean isInterface) {
            if (opcode == 186) {
                logger.warn(MessageFormat.format("[WrapMethod] [{0}] instruction INVOKEDYNAMIC cannot be instrumented.", this.context.getClassName().replaceAll("/", ".")));
                super.visitMethodInsn(opcode, owner, name, desc, isInterface);
                return;
            }
            if (!this.tryReplaceCallVoid(opcode, owner, name, desc)) {
                super.visitMethodInsn(opcode, owner, name, desc, isInterface);
            }
        }

        private boolean tryReplaceCallVoid(int opcode, String owner, String name, String desc) {
            boolean isSuperCallInOverride;
            Collection<ClassMethod> replacementMethods = this.context.getCallVoidReplacements(owner, name, desc);
            if (replacementMethods.isEmpty()) {
                return false;
            }
            if (!this.isIncludedPackage(owner)) {
                return false;
            }
            ClassMethod method = new ClassMethod(owner, name, desc);
            Iterator<ClassMethod> iterator = replacementMethods.iterator();
            if (!iterator.hasNext()) {
                return false;
            }
            ClassMethod replacementMethod = iterator.next();
            boolean bl = isSuperCallInOverride = opcode == 183 && !owner.equals(this.context.getClassName()) && this.name.equals(name) && this.desc.equals(desc);
            if (isSuperCallInOverride) {
                logger.debug(MessageFormat.format("[WrapMethod] [{0}] skipping replacement for super call in overriden method: {1}:{2}", this.context.getClassName().replaceAll("/", "."), this.name, this.desc));
                return false;
            }
            logger.debug(MessageFormat.format("[WrapMethod] [{0}] replacing call {1} to {2}", this.context.getClassName().replaceAll("/", "."), method.toString(), replacementMethod.toString()));
            super.visitMethodInsn(184, replacementMethod.getClsName(), replacementMethod.getMethodName(), replacementMethod.getMethodDesc(), false);
            this.context.markModified();
            return true;
        }
    }
}

