/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.apms.plugin.instrument.util;

import com.huawei.agconnect.apms.plugin.APMSGradlePlugin;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.regex.Pattern;
import org.gradle.api.logging.Logger;

public class FileUtil {
    private static final Logger logger = APMSGradlePlugin.getLogger();

    public static boolean isSupportJar(File archiveFile) {
        boolean matches = false;
        try {
            String canonicalPath = archiveFile.getCanonicalPath().toLowerCase(Locale.ENGLISH);
            matches = Pattern.matches("^.*/jre/lib/rt\\.jar$", canonicalPath);
        }
        catch (Exception ex) {
            logger.warn("failed to get jar resource: " + ex.getMessage());
        }
        return matches;
    }

    private static boolean isArchive(String fileName) {
        String lowerPath = fileName.toLowerCase(Locale.ENGLISH);
        return lowerPath.endsWith(".zip") || lowerPath.endsWith(".jar") || lowerPath.endsWith(".aar");
    }

    public static boolean isArchive(File f) {
        try {
            return FileUtil.isArchive(f.getCanonicalPath());
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isClass(String filename) {
        return filename.toLowerCase(Locale.ENGLISH).endsWith(".class") && !FileUtil.iskotlinModuleInfoClass(filename);
    }

    private static boolean iskotlinModuleInfoClass(String filename) {
        return filename.matches("module[-_]info\\.class");
    }

    public static boolean isClass(File f) {
        try {
            return FileUtil.isClass(f.getCanonicalPath());
        }
        catch (IOException e) {
            return false;
        }
    }
}

