/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.apms.plugin.instrument.visitor;

import com.google.common.collect.ImmutableMap;
import com.huawei.agconnect.apms.plugin.APMSGradlePlugin;
import com.huawei.agconnect.apms.plugin.instrument.Instrument;
import com.huawei.agconnect.apms.plugin.instrument.InstrumentationContext;
import com.huawei.agconnect.apms.plugin.instrument.model.LifecycleMethod;
import com.huawei.agconnect.apms.plugin.instrument.visitor.ActivityClassAdapter;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.gradle.api.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.commons.Method;

public class ActivityClassVisitor
extends ActivityClassAdapter {
    private static final Map<String, Integer> ACTIVITY_METHOD_ACCESS_MAP = ImmutableMap.of((Object)"onCreate", (Object)4, (Object)"onStart", (Object)4, (Object)"onResume", (Object)4, (Object)"onRestart", (Object)4);
    private static final String FRAGMENT_METHOD_NAME = "onCreateView";
    private static final String FRAGMENT_METHOD_DESC = "(Landroid/view/LayoutInflater;Landroid/view/ViewGroup;Landroid/os/Bundle;)Landroid/view/View;";
    private static final Logger logger = APMSGradlePlugin.getLogger();
    private static final Pattern ANDROID_PACKAGE_PATTERN = Pattern.compile("^android[x]{0,1}/.*");
    private String className;

    public ActivityClassVisitor(ClassVisitor cv, InstrumentationContext context) {
        super(cv, context, context.getActivityMethods(), ACTIVITY_TYPE[1]);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
    }

    @Override
    public void onMethodEnter(AdviceAdapter adapter, Method oldMethod, LifecycleMethod newMethod) {
        adapter.visitVarInsn(25, 0);
        adapter.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
        adapter.visitMethodInsn(182, "java/lang/Class", "getName", "()Ljava/lang/String;", false);
        String oldMethodName = oldMethod.getName();
        if (oldMethodName.equalsIgnoreCase("onCreate")) {
            adapter.invokeStatic(TRACE_MANAGER_TYPE, newMethod.getOnEnterMethod());
        } else if (oldMethodName.equalsIgnoreCase("onStart") || oldMethodName.equalsIgnoreCase("onResume") || oldMethodName.equalsIgnoreCase("onRestart")) {
            adapter.invokeStatic(APP_INSTRUMENTATION_TYPE, newMethod.getOnEnterMethod());
        }
    }

    @Override
    public void onMethodExit(AdviceAdapter adapter, Method oldMethod, LifecycleMethod newMethod) {
        adapter.invokeStatic(APP_INSTRUMENTATION_TYPE, newMethod.getOnExitMethod());
    }

    @Override
    public int provideAccessForMethod(Method method) {
        return ACTIVITY_METHOD_ACCESS_MAP.get(method.getName()) != null ? ACTIVITY_METHOD_ACCESS_MAP.get(method.getName()) : 4;
    }

    @Override
    public boolean shouldInstrumentClass(String className, String superName) {
        if (Instrument.activityList.contains(className)) {
            logger.info("className: {} need to instrument, superName:{}, this: {}", new Object[]{className, superName, ((Object)((Object)this)).getClass().getSimpleName()});
            return true;
        }
        logger.info("className: {} does not need instrument, superName: {}, this: {}", new Object[]{className, superName, ((Object)((Object)this)).getClass().getSimpleName()});
        return false;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.isFragmentInstrumented(access, name, desc)) {
            Instrument.fragmentList.add(this.className);
        }
        return mv;
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
    }

    private boolean isFragmentInstrumented(int access, String name, String desc) {
        if (null == this.className) {
            return false;
        }
        if (ANDROID_PACKAGE_PATTERN.matcher(this.className.toLowerCase(Locale.ENGLISH)).matches()) {
            return false;
        }
        return 1 == access && FRAGMENT_METHOD_NAME.equals(name) && FRAGMENT_METHOD_DESC.equals(desc);
    }
}

