/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.agcp;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.builder.model.ClassField;
import com.huawei.agconnect.agcp.ConfigParser;
import com.huawei.agconnect.agcp.SecurityConfig;
import java.io.File;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class AGCPluginBak
implements Plugin<Project> {
    private static final String CONFIG_FILE_NAME = "agconnect-services.json";
    private static final String PACKAGE_NAME_PATH = "/client/package_name";

    public void apply(Project project) {
        if (project.getPlugins().hasPlugin("com.android.application")) {
            AGCPluginBak.parseAGCConfigToResValue(project);
        }
    }

    private static void parseAGCConfigToResValue(Project project) {
        Map<String, ClassField> configValues;
        ConfigParser configParser;
        AppExtension android = (AppExtension)project.getExtensions().getByType(AppExtension.class);
        DefaultConfig defaultConfig = android.getDefaultConfig();
        File configFile = new File(project.getProjectDir(), CONFIG_FILE_NAME);
        if (!configFile.exists()) {
            return;
        }
        try {
            configParser = new ConfigParser();
            configParser.parse(configFile);
        }
        catch (Exception e) {
            throw new GradleException("ERROR: Failed to parse the AGConnect-Config file as JSON: " + e.getMessage());
        }
        AGCPluginBak.verifyConfig(android, defaultConfig.getApplicationId(), configParser.getValue(PACKAGE_NAME_PATH));
        try {
            configValues = SecurityConfig.encrypt(configParser.getValues(), "");
        }
        catch (Exception e) {
            throw new GradleException("ERROR: Failed to protect the AGConnect-Config: " + e.getMessage());
        }
        defaultConfig.addResValues(configValues);
    }

    private static void verifyConfig(AppExtension android, final String defAppId, final String pkgName) {
        android.getApplicationVariants().all((Action)new Action<ApplicationVariant>(){

            public void execute(ApplicationVariant appVariant) {
                this.verifyPackageName(appVariant);
            }

            private void verifyPackageName(ApplicationVariant appVariant) {
                String appId = appVariant.getApplicationId();
                if (appId == null || appId.isEmpty()) {
                    appId = defAppId;
                }
                if (pkgName == null || !pkgName.equals(appId)) {
                    throw new GradleException("ERROR: Failed to verify AGConnect-Config '/client/package_name', expected: '" + appId + "', but was: '" + pkgName + "'");
                }
            }
        });
    }
}

