/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.apms.plugin.instrument.visitor;

import com.google.common.collect.ImmutableMap;
import com.huawei.agconnect.apms.plugin.instrument.Instrument;
import com.huawei.agconnect.apms.plugin.instrument.InstrumentationContext;
import com.huawei.agconnect.apms.plugin.instrument.model.LifecycleMethod;
import com.huawei.agconnect.apms.plugin.instrument.visitor.ActivityClassAdapter;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.commons.Method;

public class FragmentClassVisitor
extends ActivityClassAdapter {
    private static final Map<String, Integer> FRAGMENT_METHOD_ACCESS_MAP = ImmutableMap.of((Object)"onCreateView", (Object)1, (Object)"onStart", (Object)1, (Object)"onResume", (Object)1);
    private String className;

    public FragmentClassVisitor(ClassVisitor cv, InstrumentationContext context) {
        super(cv, context, context.getFragmentMethods(), ACTIVITY_TYPE[2]);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name == null ? "" : name.replaceAll("/", ".");
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
    }

    @Override
    public void onMethodEnter(AdviceAdapter adapter, Method oldMethod, LifecycleMethod newMethod) {
        adapter.visitVarInsn(25, 0);
        adapter.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
        adapter.visitMethodInsn(182, "java/lang/Class", "getName", "()Ljava/lang/String;", false);
        adapter.visitLdcInsn((Object)this.className);
        adapter.invokeStatic(FRAGMENT_INSTRUMENTATION_TYPE, newMethod.getOnEnterMethod());
    }

    @Override
    public void onMethodExit(AdviceAdapter adapter, Method oldMethod, LifecycleMethod newMethod) {
        adapter.visitVarInsn(25, 0);
        adapter.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
        adapter.visitMethodInsn(182, "java/lang/Class", "getName", "()Ljava/lang/String;", false);
        adapter.visitLdcInsn((Object)this.className);
        adapter.invokeStatic(FRAGMENT_INSTRUMENTATION_TYPE, newMethod.getOnExitMethod());
    }

    @Override
    public int provideAccessForMethod(Method method) {
        return FRAGMENT_METHOD_ACCESS_MAP.get(method.getName()) != null ? FRAGMENT_METHOD_ACCESS_MAP.get(method.getName()) : 4;
    }

    @Override
    public boolean shouldInstrumentClass(String name, String superName) {
        return Instrument.fragmentList.contains(name);
    }
}

