/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.agcp;

import com.android.builder.model.ClassField;
import com.google.common.collect.Maps;
import com.huawei.agconnect.agcp.AGCPSecureRandom;
import com.huawei.agconnect.agcp.AesEncrypt;
import com.huawei.agconnect.agcp.AesParam;
import com.huawei.agconnect.agcp.ClassFields;
import com.huawei.agconnect.agcp.EncryptLocalResource;
import com.huawei.agconnect.agcp.Hex;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.GradleException;

public class FixedEncrypt
implements AesEncrypt {
    private static final String RES_NAME_PREFIX = "agc_";
    private static final String RX_NAME = "agc_D96112F0F656550C8068DE16CF313478D253DDAF4E18EEE01F6D94CA6DD5013F";
    private static final String RY_NAME = "agc_1F79ACBA9BD8A7666759524C3052C88689CBB5873811854517CBBE65DC268EAA";
    private static final String RZ_NAME = "agc_F56D9E20C47154729D3F411FD73FA2BDDF0330EB0A9873ACC352CC371FC5A767";
    private static final String SL_NAME = "agc_B9EAB77AB7FDFB9A9577EEAC5B15C13D00CD198883FD8D2BCF6CD048B1DB8EAC";
    private static final int AES_SIZE = 16;
    private static final String ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final int ITERATION_COUNT = 5000;
    private final EncryptLocalResource encryptLocalResource;
    private final AesParam param;

    public FixedEncrypt() {
        byte[] rxBytes = AGCPSecureRandom.getInstance().getRandom(16);
        byte[] ryBytes = AGCPSecureRandom.getInstance().getRandom(16);
        byte[] rzBytes = AGCPSecureRandom.getInstance().getRandom(16);
        byte[] slBytes = AGCPSecureRandom.getInstance().getRandom(16);
        this.param = new AesParam(rxBytes, ryBytes, rzBytes, slBytes, ALGORITHM, 5000, 16);
        this.encryptLocalResource = new EncryptLocalResource(this.param);
    }

    @Override
    public Map<String, ClassField> encryptComponent() {
        TreeMap outResValues = Maps.newTreeMap();
        outResValues.put(RX_NAME, ClassFields.newString(RX_NAME, Hex.encodeHexString(this.param.getRxBytes())));
        outResValues.put(RY_NAME, ClassFields.newString(RY_NAME, Hex.encodeHexString(this.param.getRyBytes())));
        outResValues.put(RZ_NAME, ClassFields.newString(RZ_NAME, Hex.encodeHexString(this.param.getRzBytes())));
        outResValues.put(SL_NAME, ClassFields.newString(SL_NAME, Hex.encodeHexString(this.param.getSlBytes())));
        return outResValues;
    }

    @Override
    public ClassField encryptResources(ClassField in) {
        try {
            String cipherHex = Hex.encodeHexString(this.encryptLocalResource.encrypt(in.getValue().getBytes(StandardCharsets.UTF_8)));
            String key = RES_NAME_PREFIX + in.getName();
            return ClassFields.newString(key, cipherHex);
        }
        catch (GeneralSecurityException e) {
            throw new GradleException("encryptResources error :" + e.getMessage());
        }
    }
}

