/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.apms.plugin.instrument.visitor;

import com.huawei.agconnect.apms.plugin.instrument.Instrument;
import com.huawei.agconnect.apms.plugin.instrument.InstrumentationContext;
import com.huawei.agconnect.apms.plugin.instrument.model.LifecycleMethod;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.commons.Method;

public abstract class ActivityClassAdapter
extends ClassVisitor {
    static final Type APP_INSTRUMENTATION_TYPE = Type.getObjectType((String)"com/huawei/agconnect/apms/instrument/AppInstrumentation");
    static final Type FRAGMENT_INSTRUMENTATION_TYPE = Type.getObjectType((String)"com/huawei/agconnect/apms/instrument/FragmentInstrumentation");
    static final Type TRACE_MANAGER_TYPE = Type.getObjectType((String)"com/huawei/agconnect/apms/instrument/TraceManager");
    static final String[] ACTIVITY_TYPE = new String[]{"Application", "Activity", "Fragment"};
    private Map<Method, MethodVisitorFactory> methodVisitors;
    private final InstrumentationContext context;
    private boolean instrument;
    private String superName;
    private String activityType;

    ActivityClassAdapter(ClassVisitor cv, InstrumentationContext context, Map<Method, LifecycleMethod> lifecycleMethodMap, String activityType) {
        super(458752, cv);
        this.context = context;
        this.instrument = false;
        this.activityType = activityType;
        this.initMethodVisitors(lifecycleMethodMap);
    }

    public abstract void onMethodEnter(AdviceAdapter var1, Method var2, LifecycleMethod var3);

    public abstract void onMethodExit(AdviceAdapter var1, Method var2, LifecycleMethod var3);

    public abstract int provideAccessForMethod(Method var1);

    public abstract boolean shouldInstrumentClass(String var1, String var2);

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.superName = superName;
        this.instrument = this.shouldInstrumentClass(name, superName);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (!this.instrument) {
            return mv;
        }
        if (this.context.isSkippedMethod(name, desc)) {
            return mv;
        }
        Method oldMethod = new Method(name, desc);
        if (this.methodVisitors.containsKey(oldMethod)) {
            MethodVisitor newMv = this.methodVisitors.get(oldMethod).createMethodVisitor(access, oldMethod, mv, false);
            this.methodVisitors.remove(oldMethod);
            return newMv;
        }
        return mv;
    }

    public void visitEnd() {
        if (!this.instrument) {
            super.visitEnd();
            return;
        }
        this.context.markModified();
        if (ACTIVITY_TYPE[0].equalsIgnoreCase(this.activityType) && Instrument.applicationClassName.equalsIgnoreCase("")) {
            super.visitEnd();
            return;
        }
        for (Map.Entry<Method, MethodVisitorFactory> entry : this.methodVisitors.entrySet()) {
            String methodName = entry.getKey().getName();
            String methodDesc = entry.getKey().getDescriptor();
            int access = this.provideAccessForMethod(entry.getKey());
            MethodVisitor mv = super.visitMethod(access, methodName, methodDesc, null, null);
            mv = entry.getValue().createMethodVisitor(access, entry.getKey(), mv, true);
            mv.visitCode();
            Type methodReturn = entry.getKey().getReturnType();
            if (methodReturn == Type.VOID_TYPE) {
                mv.visitInsn(177);
            } else if (methodReturn == Type.BOOLEAN_TYPE) {
                mv.visitInsn(172);
            } else {
                mv.visitInsn(173);
            }
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        super.visitEnd();
    }

    private void initMethodVisitors(Map<Method, LifecycleMethod> methodMappings) {
        this.methodVisitors = new HashMap<Method, MethodVisitorFactory>();
        for (Map.Entry<Method, LifecycleMethod> methodEntry : methodMappings.entrySet()) {
            this.methodVisitors.put(methodEntry.getKey(), new MethodVisitorFactory(methodEntry.getValue()));
        }
    }

    protected class MethodVisitorFactory {
        private LifecycleMethod lifecycleMethod;

        MethodVisitorFactory(LifecycleMethod lifecycleMethod) {
            this.lifecycleMethod = lifecycleMethod;
        }

        MethodVisitor createMethodVisitor(int access, final Method method, MethodVisitor mv, final boolean callSuper) {
            return new AdviceAdapter(458752, mv, access, method.getName(), method.getDescriptor()){

                public void visitCode() {
                    super.visitCode();
                    if (callSuper) {
                        this.loadThis();
                        for (int ii = 0; ii < method.getArgumentTypes().length; ++ii) {
                            this.loadArg(ii);
                        }
                        this.visitMethodInsn(183, ActivityClassAdapter.this.superName, method.getName(), method.getDescriptor(), false);
                    }
                }

                protected void onMethodEnter() {
                    super.onMethodEnter();
                    ActivityClassAdapter.this.onMethodEnter(this, method, MethodVisitorFactory.this.lifecycleMethod);
                }

                protected void onMethodExit(int opcode) {
                    super.onMethodExit(opcode);
                    ActivityClassAdapter.this.onMethodExit(this, method, MethodVisitorFactory.this.lifecycleMethod);
                }
            };
        }
    }
}

