/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.apms.plugin.instrument;

import com.huawei.agconnect.apms.plugin.instrument.annotation.AnnotatedMethodFactory;
import com.huawei.agconnect.apms.plugin.instrument.config.InstrumentationConfig;
import com.huawei.agconnect.apms.plugin.instrument.model.ClassData;
import com.huawei.agconnect.apms.plugin.instrument.model.ClassMethod;
import com.huawei.agconnect.apms.plugin.instrument.model.LifecycleMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.commons.Method;

public class InstrumentationContext {
    private final InstrumentationConfig config;
    private boolean classInstrumented;
    private String className;
    private String superClassName;
    private final ArrayList<String> instrumentTags = new ArrayList();
    private HashMap<String, String> skippedMethods;

    InstrumentationContext(InstrumentationConfig config) {
        this.config = config;
        this.skippedMethods = new HashMap();
        this.className = null;
        this.superClassName = null;
    }

    void reset() {
        this.classInstrumented = false;
        this.className = null;
        this.superClassName = null;
        this.instrumentTags.clear();
    }

    public void markModified() {
        this.classInstrumented = true;
    }

    public boolean isClassInstrumented() {
        return this.classInstrumented;
    }

    public void addTag(String tag) {
        this.instrumentTags.add(tag);
    }

    public void addUniqueTag(String tag) {
        ArrayList<String> commonTags = new ArrayList<String>();
        for (String tagStr : this.instrumentTags) {
            if (!tag.equals(tagStr)) continue;
            commonTags.add(tagStr);
        }
        this.instrumentTags.removeAll(commonTags);
        this.addTag(tag);
    }

    public boolean isSkippedMethod(String name, String desc) {
        return this.searchMethodMap(this.skippedMethods, name, desc);
    }

    private boolean searchMethodMap(Map<String, String> map, String name, String desc) {
        String descToMatch = map.get(this.className + "#" + name);
        return descToMatch != null;
    }

    boolean hasTag(String tag) {
        return this.instrumentTags.contains(tag);
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFriendlyClassName() {
        if (null == this.className) {
            return "";
        }
        return this.className.replaceAll("/", ".");
    }

    public String getFriendlySuperClassName() {
        if (null == this.superClassName) {
            return "";
        }
        return this.superClassName.replaceAll("/", ".");
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    ClassData newClassData(byte[] mainClassBytes) {
        return new ClassData(mainClassBytes, this.isClassInstrumented());
    }

    public ClassMethod getMethodWrapper(ClassMethod method) {
        return this.config.getMethodWrapper(method);
    }

    public Collection<ClassMethod> getCallSiteReplacements(String className, String methodName, String methodDesc) {
        return this.config.getCallSiteReplacements(className, methodName, methodDesc);
    }

    public Collection<ClassMethod> getCallVoidReplacements(String className, String methodName, String methodDesc) {
        return this.config.getCallVoidReplacements(className, methodName, methodDesc);
    }

    public AnnotatedMethodFactory getAnnotatedMethodFactory(String classDesc) {
        return this.config.getAnnotatedMethodFactory(classDesc);
    }

    public Map<Method, LifecycleMethod> getActivityMethods() {
        return this.config.getActivityMethodFactoryMap();
    }

    public Map<Method, LifecycleMethod> getApplicationMethods() {
        return this.config.getApplicationMethodFactoryMap();
    }

    public Map<Method, LifecycleMethod> getFragmentMethods() {
        return this.config.getFragmentMethodFactoryMap();
    }
}

