/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.apms.plugin.instrument.annotation;

import com.huawei.agconnect.apms.plugin.instrument.annotation.AnnotatedMethodAdapter;
import com.huawei.agconnect.apms.plugin.instrument.annotation.AnnotatedMethodFactory;
import com.huawei.agconnect.apms.plugin.instrument.model.AnnotationInfo;
import com.huawei.agconnect.apms.plugin.sdk.APMSTrace;
import org.objectweb.asm.commons.AdviceAdapter;

public class TraceAnnotationProcessor
implements AnnotatedMethodAdapter {
    private static final String TRACE_ANNOTATION_ATTR_NAME = "name";
    private static final String TRACE_ANNOTATION_ATTR_ENABLED = "enabled";
    private APMSTrace apmsTrace;
    private AnnotationInfo annotationInfo;
    private boolean isTraceAdded;

    private TraceAnnotationProcessor(AdviceAdapter adviceAdapter, AnnotationInfo annotationInfo) {
        this.apmsTrace = new APMSTrace(adviceAdapter);
        this.annotationInfo = annotationInfo;
        this.isTraceAdded = false;
    }

    @Override
    public void onMethodEnter() {
        boolean isEnable;
        Object enabled = this.annotationInfo.values.get(TRACE_ANNOTATION_ATTR_ENABLED);
        boolean bl = isEnable = !(enabled instanceof Boolean) || (Boolean)enabled != false;
        if (isEnable) {
            this.apmsTrace.start(this.annotationInfo.values.get(TRACE_ANNOTATION_ATTR_NAME).toString());
            this.isTraceAdded = true;
        }
    }

    @Override
    public void onMethodExit() {
        if (this.isTraceAdded) {
            this.apmsTrace.stop();
        }
    }

    public static class Factory
    implements AnnotatedMethodFactory {
        @Override
        public AnnotatedMethodAdapter createAnnotatedMethodInstrumentation(AdviceAdapter adviceAdapter, AnnotationInfo annotationInfo) {
            return new TraceAnnotationProcessor(adviceAdapter, annotationInfo);
        }
    }
}

