/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.apms.plugin.instrument.visitor;

import com.huawei.agconnect.apms.plugin.APMSGradlePlugin;
import com.huawei.agconnect.apms.plugin.instrument.InstrumentationContext;
import com.huawei.agconnect.apms.plugin.instrument.model.ClassMethod;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import org.gradle.api.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class WrapMethodClassVisitor
extends ClassVisitor {
    private final InstrumentationContext context;
    private static final Logger logger = APMSGradlePlugin.getLogger();

    public WrapMethodClassVisitor(ClassVisitor cv, InstrumentationContext context) {
        super(327680, cv);
        this.context = context;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String sig, String[] exceptions) {
        if (this.context.isSkippedMethod(name, desc)) {
            return super.visitMethod(access, name, desc, sig, exceptions);
        }
        return new MethodWrapMethodVisitor(super.visitMethod(access, name, desc, sig, exceptions), access, name, desc, this.context);
    }

    private static class MethodWrapMethodVisitor
    extends GeneratorAdapter {
        private String name;
        private String desc;
        private InstrumentationContext context;
        private boolean newInstructionFound = false;
        private boolean dupInstructionFound = false;

        MethodWrapMethodVisitor(MethodVisitor mv, int access, String name, String desc, InstrumentationContext context) {
            super(327680, mv, access, name, desc);
            this.name = name;
            this.desc = desc;
            this.context = context;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean isInterface) {
            if (opcode == 186) {
                logger.warn(MessageFormat.format("[WrapMethod] [{0}] instruction INVOKEDYNAMIC cannot be instrumented.", this.context.getClassName().replaceAll("/", ".")));
                super.visitMethodInsn(opcode, owner, name, desc, isInterface);
                return;
            }
            if (!this.tryReplaceCallSite(opcode, owner, name, desc) && !this.tryWrapReturnValue(opcode, owner, name, desc)) {
                super.visitMethodInsn(opcode, owner, name, desc, isInterface);
            }
        }

        public void visitTypeInsn(int opcode, String type) {
            if (opcode == 187) {
                this.newInstructionFound = true;
                this.dupInstructionFound = false;
            }
            super.visitTypeInsn(opcode, type);
        }

        public void visitInsn(int opcode) {
            if (opcode == 89) {
                this.dupInstructionFound = true;
            }
            super.visitInsn(opcode);
        }

        private boolean tryWrapReturnValue(int opcode, String owner, String name, String desc) {
            ClassMethod method = new ClassMethod(owner, name, desc);
            ClassMethod wrappingMethod = this.context.getMethodWrapper(method);
            if (wrappingMethod != null) {
                logger.debug(MessageFormat.format("[WrapMethod] [{0}] wrapping call to {1} with {2}", this.context.getClassName().replaceAll("/", "."), method.toString(), wrappingMethod.toString()));
                super.visitMethodInsn(opcode, owner, name, desc, opcode == 185);
                super.visitMethodInsn(184, wrappingMethod.getClassName(), wrappingMethod.getMethodName(), wrappingMethod.getMethodDesc(), false);
                this.context.markModified();
                return true;
            }
            return false;
        }

        private boolean tryReplaceCallSite(int opcode, String owner, String name, String desc) {
            boolean isSuperCallInOverride;
            Collection<ClassMethod> replacementMethods = this.context.getCallSiteReplacements(owner, name, desc);
            if (replacementMethods.isEmpty()) {
                return false;
            }
            ClassMethod method = new ClassMethod(owner, name, desc);
            Iterator<ClassMethod> iterator = replacementMethods.iterator();
            if (!iterator.hasNext()) {
                return false;
            }
            ClassMethod replacementMethod = iterator.next();
            boolean bl = isSuperCallInOverride = opcode == 183 && !owner.equals(this.context.getClassName()) && this.name.equals(name) && this.desc.equals(desc);
            if (isSuperCallInOverride) {
                logger.debug(MessageFormat.format("[WrapMethod] [{0}] skipping replacement for super call in overriden method: {1}:{2}", this.context.getClassName().replaceAll("/", "."), this.name, this.desc));
                return false;
            }
            if (opcode == 183 && name.equals("<init>")) {
                Method originalMethod = new Method(name, desc);
                if (this.context.getSuperClassName() != null && this.context.getSuperClassName().equals(owner)) {
                    logger.debug(MessageFormat.format("[WrapMethod] [{0}] skipping replacement for class extending {1}", this.context.getFriendlyClassName(), this.context.getFriendlySuperClassName()));
                    return false;
                }
                logger.debug(MessageFormat.format("[WrapMethod] [{0}] tracing constructor call to {1} - {2}", this.context.getFriendlyClassName(), method.toString(), owner));
                int[] locals = new int[originalMethod.getArgumentTypes().length];
                for (int i = locals.length - 1; i >= 0; --i) {
                    locals[i] = this.newLocal(originalMethod.getArgumentTypes()[i]);
                    this.storeLocal(locals[i]);
                }
                this.visitInsn(87);
                if (this.newInstructionFound && this.dupInstructionFound) {
                    this.visitInsn(87);
                }
                for (int local : locals) {
                    this.loadLocal(local);
                }
                super.visitMethodInsn(184, replacementMethod.getClassName(), replacementMethod.getMethodName(), replacementMethod.getMethodDesc(), false);
                if (this.newInstructionFound && !this.dupInstructionFound) {
                    this.visitInsn(87);
                }
            } else if (opcode == 184) {
                logger.debug(MessageFormat.format("[WrapMethod] [{0}] replacing static call {1} to {2}", this.context.getClassName().replaceAll("/", "."), method.toString(), replacementMethod.toString()));
                super.visitMethodInsn(184, replacementMethod.getClassName(), replacementMethod.getMethodName(), replacementMethod.getMethodDesc(), false);
            } else {
                Method newMethod = new Method(replacementMethod.getMethodName(), replacementMethod.getMethodDesc());
                logger.debug(MessageFormat.format("[WrapMethod] [{0}] replacing call {1} to {2}", this.context.getClassName().replaceAll("/", "."), method.toString(), replacementMethod.toString()));
                Method originalMethod2 = new Method(name, desc);
                int[] locals2 = new int[originalMethod2.getArgumentTypes().length];
                for (int j = locals2.length - 1; j >= 0; --j) {
                    locals2[j] = this.newLocal(originalMethod2.getArgumentTypes()[j]);
                    this.storeLocal(locals2[j]);
                }
                this.dup();
                this.instanceOf(newMethod.getArgumentTypes()[0]);
                Label isInstanceOfLabel = new Label();
                this.visitJumpInsn(154, isInstanceOfLabel);
                for (int local2 : locals2) {
                    this.loadLocal(local2);
                }
                super.visitMethodInsn(opcode, owner, name, desc, opcode == 185);
                Label end = new Label();
                this.visitJumpInsn(167, end);
                this.visitLabel(isInstanceOfLabel);
                this.checkCast(newMethod.getArgumentTypes()[0]);
                for (int local3 : locals2) {
                    this.loadLocal(local3);
                }
                super.visitMethodInsn(184, replacementMethod.getClassName(), replacementMethod.getMethodName(), replacementMethod.getMethodDesc(), false);
                this.visitLabel(end);
            }
            this.context.markModified();
            return true;
        }
    }
}

