/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.apms.plugin.instrument.util;

import com.huawei.agconnect.apms.plugin.APMSGradlePlugin;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.api.logging.Logger;

public class StreamUtil {
    private static final Logger LOG = APMSGradlePlugin.getLogger();
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    private StreamUtil() {
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        return StreamUtil.copy(input, output, 8192, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int copy(InputStream input, OutputStream output, int bufferSize, boolean closeStreams) throws IOException {
        try {
            int n;
            byte[] buffer = new byte[bufferSize];
            int count = 0;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += n;
            }
            int n2 = count;
            return n2;
        }
        finally {
            if (closeStreams) {
                if (null != input) {
                    try {
                        input.close();
                    }
                    catch (Exception ex) {
                        LOG.warn("failed to close input class file: " + ex.getMessage());
                    }
                }
                if (null != output) {
                    try {
                        output.close();
                    }
                    catch (Exception ex) {
                        LOG.warn("failed to close output class file: " + ex.getMessage());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] slurpBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            StreamUtil.copy(in, out);
            out.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            try {
                out.close();
            }
            catch (Exception ex) {
                LOG.warn("failed to close class file: " + ex.getMessage());
            }
        }
    }
}

