/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.config.impl;

import com.huawei.agconnect.config.impl.Hex;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class Keys {
    public static final int AES_KEY_SIZE = 16;
    private static final int KEY_ITERATION_COUNT = 5000;

    public static SecretKey buildAesKey(byte[] xBytes, byte[] yBytes, byte[] zBytes, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (xBytes.length != 16 || yBytes.length != 16 || zBytes.length != 16) {
            throw new IllegalArgumentException("invalid data for generating the key.");
        }
        String rootKeyHex = Hex.encodeHexString(Keys.getKey(xBytes, yBytes, zBytes));
        SecretKeyFactory skFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec keySpec = new PBEKeySpec(rootKeyHex.toCharArray(), salt, 5000, 128);
        SecretKey workKey = skFactory.generateSecret(keySpec);
        return new SecretKeySpec(workKey.getEncoded(), "AES");
    }

    public static byte[] getKey(byte[] xBytes, byte[] yBytes, byte[] zBytes) {
        return Keys.bytesXor(Keys.bytesShift(Keys.bytesXor(Keys.bytesShift(xBytes, -4), yBytes), 6), zBytes);
    }

    private static byte[] bytesXor(byte[] left, byte[] right) {
        if (left == null || right == null) {
            throw new NullPointerException("left or right must not be null.");
        }
        if (left.length != right.length) {
            throw new IllegalArgumentException("left and right must be the same length.");
        }
        byte[] result = new byte[left.length];
        for (int i = 0; i < left.length; ++i) {
            result[i] = (byte)(left[i] ^ right[i]);
        }
        return result;
    }

    private static byte[] bytesShift(byte[] bytes, int steps) {
        if (bytes == null) {
            throw new NullPointerException("bytes must not be null.");
        }
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = steps < 0 ? (byte)(bytes[i] << -steps) : (byte)(bytes[i] >> steps);
        }
        return bytes;
    }
}

