/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.agcp;

import com.huawei.agconnect.crash.symbol.lib.log.AGCLogger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class AGCPSecureRandom {
    private static final AGCPSecureRandom INSTANCE = new AGCPSecureRandom();
    private static final int STRONG_SECURE_RANDOM_TIMEOUT = 2;
    private static final Executor SINGLE = Executors.newSingleThreadExecutor();
    private final AtomicBoolean timeout = new AtomicBoolean(false);

    public static AGCPSecureRandom getInstance() {
        return INSTANCE;
    }

    private AGCPSecureRandom() {
    }

    public byte[] getRandom(int length) {
        byte[] bytes = new byte[length];
        if (!this.timeout.get()) {
            try {
                CompletableFuture.runAsync(() -> this.strong(bytes), SINGLE).get(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                AGCLogger.warn((String)"await failed");
                this.timeout.set(true);
            }
        }
        if (this.timeout.get()) {
            AGCLogger.warn((String)"use default SecureRandom instead");
            this.normal(bytes);
        }
        return bytes;
    }

    private void normal(byte[] bytes) {
        SecureRandom random = new SecureRandom();
        random.nextBytes(bytes);
    }

    private void strong(byte[] bytes) {
        try {
            SecureRandom secureRandom = SecureRandom.getInstanceStrong();
            secureRandom.nextBytes(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            AGCLogger.warn((String)("NoSuchAlgorithmException " + e.getMessage()));
            this.timeout.set(true);
        }
    }
}

