/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.apms.plugin.instrument.model;

import com.huawei.agconnect.apms.plugin.instrument.exception.InstrumentException;

public class ClassMethod {
    private String clsName;
    private String methodName;
    private String methodDesc;

    public ClassMethod(String clsName, String methodName, String methodDesc) {
        this.clsName = clsName;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
    }

    public static ClassMethod getClassMethod(String methodSign) {
        try {
            String methodDesc;
            int descIndex = methodSign.lastIndexOf(40);
            if (descIndex == -1) {
                descIndex = methodSign.length();
                methodDesc = "";
            } else {
                methodDesc = methodSign.substring(descIndex);
            }
            String beforeMethodDesc = methodSign.substring(0, descIndex);
            int methodIndex = beforeMethodDesc.lastIndexOf(46);
            return new ClassMethod(methodSign.substring(0, methodIndex), methodSign.substring(methodIndex + 1, descIndex), methodDesc);
        }
        catch (Exception ex) {
            throw new InstrumentException("[ClassMethod] an error occurred while parsing " + methodSign, ex);
        }
    }

    public String getClsName() {
        return this.clsName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodDesc() {
        return this.methodDesc;
    }

    public String toString() {
        return this.clsName + '.' + this.methodName + this.methodDesc;
    }
}

