/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.apms.plugin.instrument.visitor;

import com.huawei.agconnect.apms.plugin.APMSGradlePlugin;
import com.huawei.agconnect.apms.plugin.instrument.InstrumentationContext;
import org.gradle.api.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.GeneratorAdapter;

public class APMSClassVisitor
extends ClassVisitor {
    private final InstrumentationContext context;
    private static final Logger logger = APMSGradlePlugin.getLogger();

    public APMSClassVisitor(ClassVisitor cv, InstrumentationContext context) {
        super(458752, cv);
        this.context = context;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.context.getClassName().equals("com/huawei/agconnect/apms/APMS") && name.equals("isInstrumented")) {
            return new APMSMethodVisitor(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.context.getClassName().equals("com/huawei/agconnect/apms/Agent") && name.equals("VERSION") && !value.equals(APMSGradlePlugin.getPluginVersion())) {
            logger.warn("--W- [APMSClassVisitor] 'agconnect-apms' version [" + value + "] is not same with 'agconnect-apms-plugin' version [" + APMSGradlePlugin.getPluginVersion() + "], please update one of them, or invalidate AndroidStudio cache if these versions have been same.");
        }
        return super.visitField(access, name, desc, signature, value);
    }

    private class APMSMethodVisitor
    extends GeneratorAdapter {
        APMSMethodVisitor(MethodVisitor mv, int access, String name, String desc) {
            super(458752, mv, access, name, desc);
        }

        public void visitCode() {
            super.visitInsn(4);
            super.visitInsn(172);
            logger.info("[APMSMethodVisitor] marking APMS SDK as instrumented.");
            APMSClassVisitor.this.context.markModified();
        }
    }
}

