/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.apms.plugin.instrument.visitor;

import com.google.common.collect.ImmutableMap;
import com.huawei.agconnect.apms.plugin.instrument.Instrument;
import com.huawei.agconnect.apms.plugin.instrument.InstrumentationContext;
import com.huawei.agconnect.apms.plugin.instrument.model.LifecycleMethod;
import com.huawei.agconnect.apms.plugin.instrument.visitor.ActivityClassAdapter;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.commons.Method;

public class ApplicationClassVisitor
extends ActivityClassAdapter {
    private static final Map<String, Integer> APPLICATION_METHOD_ACCESS_MAP = ImmutableMap.of((Object)"attachBaseContext", (Object)4, (Object)"onCreate", (Object)1);

    public ApplicationClassVisitor(ClassVisitor cv, InstrumentationContext context) {
        super(cv, context, context.getApplicationMethods(), ACTIVITY_TYPE[0]);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
    }

    @Override
    public void onMethodEnter(AdviceAdapter adapter, Method oldMethod, LifecycleMethod newMethod) {
        if (oldMethod.getName().equalsIgnoreCase("attachBaseContext")) {
            adapter.visitVarInsn(25, 1);
            adapter.invokeStatic(APP_INSTRUMENTATION_TYPE, newMethod.getOnEnterMethod());
        } else if (oldMethod.getName().equalsIgnoreCase("onCreate")) {
            adapter.visitVarInsn(25, 0);
            adapter.visitMethodInsn(182, Instrument.applicationClassName, "getApplicationContext", "()Landroid/content/Context;", false);
            adapter.invokeStatic(APP_INSTRUMENTATION_TYPE, newMethod.getOnEnterMethod());
        }
    }

    @Override
    public void onMethodExit(AdviceAdapter adapter, Method oldMethod, LifecycleMethod newMethod) {
        adapter.invokeStatic(APP_INSTRUMENTATION_TYPE, newMethod.getOnExitMethod());
    }

    @Override
    public int provideAccessForMethod(Method method) {
        return APPLICATION_METHOD_ACCESS_MAP.get(method.getName()) != null ? APPLICATION_METHOD_ACCESS_MAP.get(method.getName()) : 4;
    }

    @Override
    public boolean shouldInstrumentClass(String name, String superName) {
        return Instrument.applicationClassName.equalsIgnoreCase(name);
    }
}

