/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.agcp;

import com.android.builder.model.ClassField;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.huawei.agconnect.agcp.AGCPSecureRandom;
import com.huawei.agconnect.agcp.AesEncrypt;
import com.huawei.agconnect.agcp.AesParam;
import com.huawei.agconnect.agcp.ClassFields;
import com.huawei.agconnect.agcp.EncryptLocalResource;
import com.huawei.agconnect.agcp.Hex;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.GradleException;

public class FlexibleEncrypt
implements AesEncrypt {
    private static final String RES_NAME_PREFIX = "agc_plugin_";
    private static final String CRYPTO = "crypto";
    private static final String CRYPTO_COMPONENT = "crypto_component";
    private static final String ALGORITHM = "PBKDF2WithHmacSHA256";
    private static final int ITERATION_COUNT = 1;
    private final int size;
    private final EncryptLocalResource encryptLocalResource;
    private final AesParam param;
    private final String aesType;

    public FlexibleEncrypt(String aesType) {
        this.aesType = aesType;
        if ("AES128".equals(aesType)) {
            this.size = 16;
        } else if ("AES256".equals(aesType)) {
            this.size = 32;
        } else {
            throw new GradleException(String.format("This encryption {%s} format is not supported.", aesType));
        }
        byte[] rxBytes = AGCPSecureRandom.getInstance().getRandom(this.size);
        byte[] ryBytes = AGCPSecureRandom.getInstance().getRandom(this.size);
        byte[] rzBytes = AGCPSecureRandom.getInstance().getRandom(this.size);
        byte[] slBytes = AGCPSecureRandom.getInstance().getRandom(this.size);
        this.param = new AesParam(rxBytes, ryBytes, rzBytes, slBytes, ALGORITHM, 1, this.size);
        this.encryptLocalResource = new EncryptLocalResource(this.param);
    }

    @Override
    public Map<String, ClassField> encryptComponent() {
        TreeMap outResValues = Maps.newTreeMap();
        try {
            outResValues.put(RES_NAME_PREFIX + Hex.encodeHexString(Hex.sha256(CRYPTO.getBytes(StandardCharsets.UTF_8))), ClassFields.newString("", Hex.encodeHexString(this.aesType.getBytes(StandardCharsets.UTF_8))));
            JsonObject component = new JsonObject();
            component.addProperty("rx", Hex.encodeHexString(this.param.getRxBytes()));
            component.addProperty("ry", Hex.encodeHexString(this.param.getRyBytes()));
            component.addProperty("rz", Hex.encodeHexString(this.param.getRzBytes()));
            component.addProperty("salt", Hex.encodeHexString(this.param.getSlBytes()));
            component.addProperty("iterationCount", (Number)1);
            component.addProperty("algorithm", ALGORITHM);
            outResValues.put(RES_NAME_PREFIX + Hex.encodeHexString(Hex.sha256(CRYPTO_COMPONENT.getBytes(StandardCharsets.UTF_8))), ClassFields.newString("", Hex.encodeHexString(component.toString().getBytes(StandardCharsets.UTF_8))));
        }
        catch (NoSuchAlgorithmException e) {
            throw new GradleException("encryptComponent error :" + e.getMessage());
        }
        return outResValues;
    }

    @Override
    public ClassField encryptResources(ClassField in) {
        try {
            String cipherHex = Hex.encodeHexString(this.encryptLocalResource.encrypt(in.getValue().getBytes(StandardCharsets.UTF_8)));
            String key = RES_NAME_PREFIX + in.getName();
            return ClassFields.newString(key, cipherHex);
        }
        catch (GeneralSecurityException e) {
            throw new GradleException("encryptResources error :" + e.getMessage());
        }
    }
}

