/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.apms.plugin.instrument.model;

import com.huawei.agconnect.apms.plugin.instrument.exception.InstrumentException;
import org.objectweb.asm.commons.Method;

public class ClassMethod {
    private String className;
    private String methodName;
    private String methodDesc;

    public ClassMethod(String className, String methodName, String methodDesc) {
        this.className = className;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
    }

    public static ClassMethod getClassMethod(String signature) {
        try {
            String methodDesc;
            int descIndex = signature.lastIndexOf(40);
            if (descIndex == -1) {
                descIndex = signature.length();
                methodDesc = "";
            } else {
                methodDesc = signature.substring(descIndex);
            }
            String beforeMethodDesc = signature.substring(0, descIndex);
            int methodIndex = beforeMethodDesc.lastIndexOf(46);
            return new ClassMethod(signature.substring(0, methodIndex), signature.substring(methodIndex + 1, descIndex), methodDesc);
        }
        catch (Exception ex) {
            throw new InstrumentException("[ClassMethod] an error occurred while parsing " + signature, ex);
        }
    }

    Method getMethod() {
        return new Method(this.methodName, this.methodDesc);
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodDesc() {
        return this.methodDesc;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.className == null ? 0 : this.className.hashCode());
        result = prime * result + (this.methodDesc == null ? 0 : this.methodDesc.hashCode());
        result = prime * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassMethod other = (ClassMethod)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.methodDesc == null ? other.methodDesc != null : !this.methodDesc.equals(other.methodDesc)) {
            return false;
        }
        if (this.methodName == null) {
            return other.methodName == null;
        }
        return this.methodName.equals(other.methodName);
    }

    public String toString() {
        return this.className + '.' + this.methodName + this.methodDesc;
    }
}

