/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.agcp;

import com.huawei.agconnect.agcp.AesParam;
import com.huawei.agconnect.agcp.Hex;
import com.huawei.agconnect.crash.symbol.lib.log.AGCLogger;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class Keys {
    public static SecretKey buildAesKey(AesParam param) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (param == null || !param.isValid()) {
            throw new IllegalArgumentException("invalid data for generating the key.");
        }
        try {
            String rootKeyHex = Hex.encodeHexString(Keys.getKey(param.getRxBytes(), param.getRyBytes(), param.getRzBytes()));
            SecretKeyFactory skFactory = SecretKeyFactory.getInstance(param.getAlgorithm());
            PBEKeySpec keySpec = new PBEKeySpec(rootKeyHex.toCharArray(), param.getSlBytes(), param.getIterationCount(), param.getKeySize() * 8);
            SecretKey workKey = skFactory.generateSecret(keySpec);
            return new SecretKeySpec(workKey.getEncoded(), "AES");
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            AGCLogger.error((String)("create SecretKey error :" + e.getMessage()));
            return null;
        }
    }

    private static byte[] getKey(byte[] xBytes, byte[] yBytes, byte[] zBytes) {
        byte[] copyXByte = new byte[xBytes.length];
        System.arraycopy(xBytes, 0, copyXByte, 0, xBytes.length);
        return Keys.bytesXor(Keys.bytesShift(Keys.bytesXor(Keys.bytesShift(copyXByte, -4), yBytes), 6), zBytes);
    }

    private static byte[] bytesXor(byte[] left, byte[] right) {
        if (left == null || right == null) {
            throw new NullPointerException("left or right must not be null.");
        }
        if (left.length != right.length) {
            throw new IllegalArgumentException("left and right must be the same length.");
        }
        byte[] result = new byte[left.length];
        for (int i = 0; i < left.length; ++i) {
            result[i] = (byte)(left[i] ^ right[i]);
        }
        return result;
    }

    private static byte[] bytesShift(byte[] bytes, int steps) {
        if (bytes == null) {
            throw new NullPointerException("bytes must not be null.");
        }
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = steps < 0 ? (byte)(bytes[i] << -steps) : (byte)(bytes[i] >> steps);
        }
        return bytes;
    }
}

