/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.agcp;

import com.android.builder.internal.ClassFieldImpl;
import com.android.builder.model.ClassField;
import com.google.common.collect.Maps;
import com.huawei.agconnect.agcp.ClassFields;
import com.huawei.agconnect.config.impl.Hex;
import com.huawei.agconnect.config.impl.Keys;
import com.huawei.agconnect.config.impl.SHA;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

class SecurityConfig {
    private static final String RX_NAME = "agc_D96112F0F656550C8068DE16CF313478D253DDAF4E18EEE01F6D94CA6DD5013F";
    private static final String RY_NAME = "agc_1F79ACBA9BD8A7666759524C3052C88689CBB5873811854517CBBE65DC268EAA";
    private static final String RZ_NAME = "agc_F56D9E20C47154729D3F411FD73FA2BDDF0330EB0A9873ACC352CC371FC5A767";
    private static final String SL_NAME = "agc_B9EAB77AB7FDFB9A9577EEAC5B15C13D00CD198883FD8D2BCF6CD048B1DB8EAC";

    SecurityConfig() {
    }

    static Map<String, ClassField> encrypt(Map<String, ClassField> resValues, String encryptComponent) throws UnsupportedEncodingException, GeneralSecurityException {
        TreeMap outResValues = Maps.newTreeMap();
        byte[] rxBytes = SecurityConfig.getRandom(encryptComponent, Type.RX);
        String rxHex = Hex.encodeHexString(rxBytes);
        byte[] ryBytes = SecurityConfig.getRandom(encryptComponent, Type.RY);
        String ryHex = Hex.encodeHexString(ryBytes);
        byte[] rzBytes = SecurityConfig.getRandom(encryptComponent, Type.RZ);
        String rzHex = Hex.encodeHexString(rzBytes);
        byte[] slBytes = SecurityConfig.getRandom(encryptComponent, Type.SL);
        String slHex = Hex.encodeHexString(slBytes);
        outResValues.put(RX_NAME, ClassFields.newString(RX_NAME, rxHex));
        outResValues.put(RY_NAME, ClassFields.newString(RY_NAME, ryHex));
        outResValues.put(RZ_NAME, ClassFields.newString(RZ_NAME, rzHex));
        outResValues.put(SL_NAME, ClassFields.newString(SL_NAME, slHex));
        SecretKey key = Keys.buildAesKey(rxBytes, ryBytes, rzBytes, slBytes);
        for (Map.Entry<String, ClassField> entry : resValues.entrySet()) {
            ClassField cf = entry.getValue();
            String cipherHex = Hex.encodeHexString(SecurityConfig.encryptAes128(key, cf.getValue().getBytes("UTF-8")));
            outResValues.put(entry.getKey(), new ClassFieldImpl(cf.getType(), cf.getName(), cipherHex));
        }
        return outResValues;
    }

    private static byte[] encryptAes128(SecretKey key, byte[] text) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, key);
        byte[] cipherText = cipher.doFinal(text);
        byte[] iv = cipher.getIV();
        if (iv == null) {
            throw new GeneralSecurityException("Fail to receive IV.");
        }
        byte[] cipherTextWithIV = new byte[1 + iv.length + cipherText.length];
        cipherTextWithIV[0] = 0;
        System.arraycopy(iv, 0, cipherTextWithIV, 1, iv.length);
        System.arraycopy(cipherText, 0, cipherTextWithIV, iv.length + 1, cipherText.length);
        return cipherTextWithIV;
    }

    private static byte[] getSecureRandom(int size) {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[size];
        random.nextBytes(bytes);
        return bytes;
    }

    private static byte[] getRandom(String encryptSeed, Type type) {
        if (encryptSeed == null || "".equals(encryptSeed)) {
            return SecurityConfig.getSecureRandom(16);
        }
        byte[] bytes = new byte[16];
        try {
            String hex = Hex.encodeHexString(SHA.sha256(encryptSeed.getBytes("UTF-8")));
            if (hex.length() == 64) {
                bytes = hex.substring(16 * type.ordinal(), 16 * type.ordinal() + 16).getBytes("UTF-8");
            }
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            bytes = new byte[16];
        }
        return bytes;
    }

    static enum Type {
        RX,
        RY,
        RZ,
        SL;

    }
}

