/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.agcp;

import com.huawei.agconnect.https.Backend;
import com.huawei.agconnect.https.ClientTokenRequest;
import com.huawei.agconnect.https.ClientTokenResponse;
import com.huawei.agconnect.https.UploadRequest;
import com.huawei.agconnect.https.UploadResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class UploadBackend {
    public static String getClientToken(Map<String, String> jsonValues) {
        ClientTokenRequest request = new ClientTokenRequest();
        request.setApp_id(jsonValues.get("/client/app_id"));
        request.setClient_id(jsonValues.get("/client/client_id"));
        request.setClient_secret(jsonValues.get("/client/client_secret"));
        ArrayList<String> hosts = new ArrayList<String>();
        hosts.add(jsonValues.get("/agcgw/url"));
        String backHost = jsonValues.get("/agcgw/backurl");
        if (backHost != null && !"".equals(backHost)) {
            hosts.add(backHost);
        }
        request.setHosts(hosts);
        ClientTokenResponse response = Backend.postJson(request, ClientTokenResponse.class);
        if (response != null) {
            return response.getAccess_token();
        }
        return null;
    }

    public static UploadResponse uploadMapping(Map<String, String> map, String appVer, String token, File file) {
        return UploadBackend.upload(1, map, appVer, token, file);
    }

    public static UploadResponse uploadSymbol(Map<String, String> map, String appVer, String token, File file) {
        return UploadBackend.upload(0, map, appVer, token, file);
    }

    private static UploadResponse upload(int type, Map<String, String> map, String appVer, String token, File file) {
        UploadRequest request = new UploadRequest();
        String host = map.get("/service/analytics/collector_url");
        String[] array = host.split(",");
        request.setType(type);
        request.setHosts(Arrays.asList(array));
        request.setVersion(appVer);
        request.setToken("Bearer " + token);
        request.setAppid(map.get("/client/app_id"));
        request.setClientid(map.get("/client/client_id"));
        request.setFile(file);
        return Backend.postFile(request, UploadResponse.class);
    }
}

