/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect;

import android.content.Context;
import com.huawei.agconnect.AGCRoutePolicy;
import com.huawei.agconnect.AGConnectOptions;
import com.huawei.agconnect.CustomAuthProvider;
import com.huawei.agconnect.CustomCredentialsProvider;
import com.huawei.agconnect.config.a.b;
import com.huawei.agconnect.core.Service;
import com.huawei.agconnect.core.service.auth.AuthProvider;
import com.huawei.agconnect.core.service.auth.CredentialsProvider;
import com.huawei.agconnect.core.service.auth.OnTokenListener;
import com.huawei.agconnect.core.service.auth.Token;
import com.huawei.hmf.tasks.Task;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AGConnectOptionsBuilder {
    private static final String PRODUCT_ID_PATH = "/client/product_id";
    private static final String APP_ID_PATH = "/client/app_id";
    private static final String CP_ID_PATH = "/client/cp_id";
    private static final String API_KEY_PATH = "/client/api_key";
    private static final String CLIENT_ID_PATH = "/client/client_id";
    private static final String CLIENT_SECRET_PATH = "/client/client_secret";
    private String packageName;
    private AGCRoutePolicy routePolicy = AGCRoutePolicy.UNKNOWN;
    private InputStream inputStream;
    private final Map<String, String> customConfigMap = new HashMap<String, String>();
    private final List<Service> customServices = new ArrayList<Service>();

    public AGConnectOptionsBuilder setProductId(String string) {
        this.customConfigMap.put(PRODUCT_ID_PATH, string);
        return this;
    }

    public AGConnectOptionsBuilder setAppId(String string) {
        this.customConfigMap.put(APP_ID_PATH, string);
        return this;
    }

    public AGConnectOptionsBuilder setCPId(String string) {
        this.customConfigMap.put(CP_ID_PATH, string);
        return this;
    }

    public AGConnectOptionsBuilder setClientId(String string) {
        this.customConfigMap.put(CLIENT_ID_PATH, string);
        return this;
    }

    public AGConnectOptionsBuilder setClientSecret(String string) {
        this.customConfigMap.put(CLIENT_SECRET_PATH, string);
        return this;
    }

    public AGConnectOptionsBuilder setApiKey(String string) {
        this.customConfigMap.put(API_KEY_PATH, string);
        return this;
    }

    public AGConnectOptionsBuilder setCustomValue(String string, String string2) {
        this.customConfigMap.put(string, string2);
        return this;
    }

    public AGConnectOptionsBuilder setCustomCredentialProvider(final CustomCredentialsProvider customCredentialsProvider) {
        if (customCredentialsProvider != null) {
            Service service = Service.builder(CredentialsProvider.class, new CredentialsProvider(){

                @Override
                public Task<Token> getTokens() {
                    return customCredentialsProvider.getTokens(false);
                }

                @Override
                public Task<Token> getTokens(boolean bl) {
                    return customCredentialsProvider.getTokens(bl);
                }
            }).build();
            this.customServices.add(service);
        }
        return this;
    }

    public AGConnectOptionsBuilder setCustomAuthProvider(final CustomAuthProvider customAuthProvider) {
        if (customAuthProvider != null) {
            Service service = Service.builder(AuthProvider.class, new AuthProvider(){

                @Override
                public Task<Token> getTokens() {
                    return customAuthProvider.getTokens(false);
                }

                @Override
                public Task<Token> getTokens(boolean bl) {
                    return customAuthProvider.getTokens(bl);
                }

                @Override
                public String getUid() {
                    return "";
                }

                @Override
                public void addTokenListener(OnTokenListener onTokenListener) {
                }

                @Override
                public void removeTokenListener(OnTokenListener onTokenListener) {
                }
            }).build();
            this.customServices.add(service);
        }
        return this;
    }

    public AGConnectOptionsBuilder setRoutePolicy(AGCRoutePolicy aGCRoutePolicy) {
        this.routePolicy = aGCRoutePolicy;
        return this;
    }

    public AGConnectOptionsBuilder setPackageName(String string) {
        this.packageName = string;
        return this;
    }

    public AGConnectOptionsBuilder setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public AGConnectOptions build(Context context) {
        return new b(context, this.packageName, this.routePolicy, this.inputStream, this.customConfigMap, this.customServices, null);
    }

    public AGConnectOptions build(Context context, String string) {
        return new b(context, this.packageName, this.routePolicy, this.inputStream, this.customConfigMap, this.customServices, string);
    }
}

