/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.apms.plugin.instrument;

import com.huawei.agconnect.apms.plugin.APMSGradlePlugin;
import com.huawei.agconnect.apms.plugin.instrument.Instrument;
import com.huawei.agconnect.apms.plugin.instrument.model.ClassData;
import com.huawei.agconnect.apms.plugin.instrument.util.FileUtil;
import com.huawei.agconnect.apms.plugin.instrument.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.gradle.api.logging.Logger;

public class ClassTransformer {
    private static final String MANIFEST_TRANSFORMED_BY_KEY = "Transformed-By";
    private static final String MANIFEST_SHA1_DIGEST_KEY = "SHA1-Digest";
    private static final String MANIFEST_SHA_256_DIGEST_KEY = "SHA-256-Digest";
    private static final Logger logger = APMSGradlePlugin.getLogger();
    private File inputFile;
    private File outputFile;
    private Instrument instrument;
    private ClassData classData = null;
    private boolean noopTransform = false;
    private WriteMode writeMode = WriteMode.modified;

    private ClassTransformer() {
        this.inputFile = new File(".");
        this.outputFile = new File(".");
        try {
            this.instrument = new Instrument();
        }
        catch (Exception e) {
            logger.error("[Transformer] " + e);
        }
    }

    public ClassTransformer(File classPath, File outputDir) {
        this();
        this.inputFile = classPath;
        this.outputFile = outputDir;
        if (classPath.isDirectory()) {
            this.inputFile = classPath;
        }
    }

    public ClassTransformer(JarFile jarFile, File outputJar) {
        this();
        File jar = new File(jarFile.getName());
        this.inputFile = jar.getParentFile();
        this.outputFile = outputJar;
    }

    private byte[] transformClassBytes(String classPathname, byte[] bytes) {
        if (this.noopTransform) {
            return bytes;
        }
        if (FileUtil.isClass(classPathname)) {
            try {
                if (bytes != null) {
                    logger.debug(String.format(Locale.ENGLISH, "[Transformer] transforming class %s", classPathname));
                    this.classData = this.instrument.visitClassBytes(bytes);
                    if (this.classData != null && this.classData.isModified() && this.classData.getMainClassBytes().length > 0) {
                        return this.classData.getMainClassBytes();
                    }
                }
            }
            catch (Exception e) {
                logger.error("[Transformer] " + e);
            }
        }
        return bytes;
    }

    private ByteArrayInputStream processClassBytes(File classFile, InputStream classFileInputStream) throws IOException {
        ByteArrayInputStream processedClassBytesStream;
        byte[] classBytes = StreamUtil.slurpBytes(classFileInputStream);
        byte[] transformedClassBytes = this.transformClassBytes(classFile.getPath(), classBytes);
        if (transformedClassBytes == null) {
            processedClassBytesStream = new ByteArrayInputStream(classBytes);
        } else {
            if (classBytes.length != transformedClassBytes.length && this.classData != null && this.classData.isModified()) {
                logger.info(String.format(Locale.ENGLISH, "[Transformer] rewriting class %s, before[%s] after[%s].", classFile.getPath(), classBytes.length, transformedClassBytes.length));
            }
            processedClassBytesStream = new ByteArrayInputStream(transformedClassBytes);
        }
        return processedClassBytesStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean transformClassFile(File classFile) {
        boolean didProcessClass;
        block13: {
            didProcessClass = false;
            try {
                ByteArrayInputStream classBytesOutputStream;
                FileInputStream classBytesInputStream;
                block14: {
                    if (FileUtil.isArchive(classFile)) {
                        didProcessClass = this.transformAndExplodeArchive(classFile);
                        break block13;
                    }
                    if (classFile.isDirectory()) {
                        didProcessClass = this.transformDirectory(classFile);
                        break block13;
                    }
                    String classpath = classFile.getCanonicalPath();
                    if (classpath.startsWith(this.inputFile.getAbsolutePath())) {
                        classpath = classpath.substring(this.inputFile.getAbsolutePath().length() + 1);
                    }
                    File transformedClassFile = new File(this.outputFile, classpath);
                    classBytesInputStream = null;
                    classBytesOutputStream = null;
                    try {
                        classBytesInputStream = new FileInputStream(classFile);
                        if (FileUtil.isClass(classFile)) {
                            classBytesOutputStream = this.processClassBytes(new File(classpath), classBytesInputStream);
                            didProcessClass = this.writeClassFile(classBytesOutputStream, transformedClassFile);
                            break block14;
                        }
                        logger.debug(String.format(Locale.ENGLISH, "[Transformer] file %s ignored.", classFile.getName()));
                        didProcessClass = this.writeClassFile(classBytesInputStream, transformedClassFile);
                    }
                    catch (RuntimeException e) {
                        logger.error("[Transformer] runtimeException occurred while transforming class file: " + e);
                        this.closeQuietly(classBytesInputStream);
                        this.closeQuietly(classBytesOutputStream);
                        break block13;
                    }
                    catch (Exception e2) {
                        logger.error("[Transformer] exception occurred while transforming class file: " + e2);
                        didProcessClass = this.writeClassFile(classBytesInputStream, transformedClassFile);
                        this.closeQuietly(classBytesInputStream);
                        this.closeQuietly(classBytesOutputStream);
                        break block13;
                        {
                            catch (Throwable throwable) {
                                this.closeQuietly(classBytesInputStream);
                                this.closeQuietly(classBytesOutputStream);
                                throw throwable;
                            }
                        }
                    }
                }
                this.closeQuietly(classBytesInputStream);
                this.closeQuietly(classBytesOutputStream);
            }
            catch (RuntimeException e2) {
                logger.error("[Transformer] runtimeException occurred while transforming class file: " + e2);
            }
            catch (Exception e2) {
                logger.error("[Transformer] exception occurred while transforming class file: " + e2);
            }
        }
        return didProcessClass;
    }

    public boolean transformDirectory(File directory) {
        File[] files;
        boolean didProcessDirectory = false;
        if (directory.isDirectory() && null != (files = directory.listFiles())) {
            for (File f : files) {
                didProcessDirectory |= this.transformClassFile(f);
            }
        }
        return didProcessDirectory;
    }

    private boolean transformAndExplodeArchive(File archiveFile) throws IOException {
        return this.transformArchive(archiveFile, true);
    }

    public boolean transformArchive(File archiveFile) throws IOException {
        return this.transformArchive(archiveFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean transformArchive(File archiveFile, boolean explodeJar) throws IOException {
        JarFile jarFile;
        JarOutputStream jarOutputStream;
        JarInputStream jarInputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        FileInputStream archiveFileInputStream;
        boolean didProcessArchive;
        block38: {
            block37: {
                didProcessArchive = false;
                if (FileUtil.isSupportJar(archiveFile)) {
                    logger.debug(String.format(Locale.ENGLISH, "[Transformer] skipping support jar %s", archiveFile.getPath()));
                    return false;
                }
                logger.debug(String.format(Locale.ENGLISH, "[Transformer] transforming archive %s", archiveFile.getCanonicalPath()));
                archiveFileInputStream = null;
                byteArrayOutputStream = null;
                jarInputStream = null;
                jarOutputStream = null;
                jarFile = null;
                JarEntry manifest = new JarEntry("META-INF/MANIFEST.MF");
                boolean doTransform = true;
                jarFile = new JarFile(archiveFile);
                byteArrayOutputStream = new ByteArrayOutputStream();
                archiveFileInputStream = new FileInputStream(archiveFile);
                jarInputStream = new JarInputStream(archiveFileInputStream);
                jarOutputStream = new JarOutputStream(byteArrayOutputStream);
                jarOutputStream.putNextEntry(manifest);
                Manifest realManifest = jarFile.getManifest();
                if (realManifest != null) {
                    realManifest.getMainAttributes().put(new Attributes.Name(MANIFEST_TRANSFORMED_BY_KEY), "APMS Android Agent");
                    Map<String, Attributes> entries = realManifest.getEntries();
                    for (String entryKey : entries.keySet()) {
                        Attributes attrs = realManifest.getAttributes(entryKey);
                        for (Object attr : attrs.keySet()) {
                            String attrKeyName = attr.toString();
                            if (!MANIFEST_SHA1_DIGEST_KEY.equals(attrKeyName) && !MANIFEST_SHA_256_DIGEST_KEY.equals(attrKeyName)) continue;
                            doTransform = false;
                        }
                    }
                    realManifest.write(jarOutputStream);
                }
                jarOutputStream.flush();
                jarOutputStream.closeEntry();
                if (doTransform) break block37;
                logger.info(String.format(Locale.ENGLISH, "[Transformer] skipping signed jar %s", archiveFile.getPath()));
                boolean entries = StreamUtil.copy(new FileInputStream(archiveFile), new FileOutputStream(this.outputFile)) > 0;
                this.closeQuietly(jarFile);
                this.closeQuietly(archiveFileInputStream);
                this.closeQuietly(byteArrayOutputStream);
                this.closeQuietly(jarInputStream);
                this.closeQuietly(jarOutputStream);
                return entries;
            }
            try {
                JarEntry entry = jarInputStream.getNextJarEntry();
                while (entry != null) {
                    String jarEntryPath = entry.getName();
                    if (!entry.isDirectory() && FileUtil.isClass(jarEntryPath)) {
                        JarEntry jarEntry = new JarEntry(jarEntryPath);
                        File archiveClassFile = new File(this.outputFile, jarEntryPath);
                        InputStream classBytesInputStream = null;
                        ByteArrayInputStream classBytesOutputStream = null;
                        jarEntry.setTime(entry.getTime());
                        jarOutputStream.putNextEntry(jarEntry);
                        try {
                            classBytesInputStream = jarFile.getInputStream(entry);
                            classBytesOutputStream = this.processClassBytes(archiveClassFile, classBytesInputStream);
                            if (explodeJar) {
                                didProcessArchive |= this.writeClassFile(classBytesOutputStream, archiveClassFile);
                            } else {
                                this.writeClassStream(classBytesOutputStream, jarOutputStream);
                                didProcessArchive = true;
                            }
                            jarOutputStream.flush();
                            jarOutputStream.closeEntry();
                            this.closeQuietly(classBytesInputStream);
                            this.closeQuietly(classBytesOutputStream);
                        }
                        catch (Exception e) {
                            try {
                                logger.error("[Transformer] exception occurred while transforming archive: " + e);
                                if (explodeJar) {
                                    didProcessArchive |= this.writeClassFile(classBytesInputStream, archiveClassFile);
                                } else {
                                    this.writeClassStream(classBytesInputStream, jarOutputStream);
                                    didProcessArchive = true;
                                }
                                this.closeQuietly(classBytesInputStream);
                                this.closeQuietly(classBytesOutputStream);
                            }
                            catch (Throwable throwable) {
                                this.closeQuietly(classBytesInputStream);
                                this.closeQuietly(classBytesOutputStream);
                                throw throwable;
                            }
                        }
                    }
                    entry = jarInputStream.getNextJarEntry();
                }
                if (!didProcessArchive) break block38;
                File rewrittenJar = new File(this.outputFile.getAbsolutePath());
                if (!archiveFile.getAbsolutePath().equals(rewrittenJar.getCanonicalPath())) {
                    logger.debug(String.format(Locale.ENGLISH, "[Transformer] rewriting archive to %s", rewrittenJar.getCanonicalPath()));
                    this.closeQuietly(jarOutputStream);
                    try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                        this.writeClassFile(byteArrayInputStream, rewrittenJar);
                        break block38;
                    }
                    catch (RuntimeException e2) {
                        logger.error("[Transformer] runtimeException occurred while transforming archive: " + e2);
                    }
                    catch (Exception e2) {
                        logger.error("[Transformer] exception occurred while transforming archive: " + e2);
                    }
                    break block38;
                }
                logger.error("[Transformer] refusing to overwrite archive " + rewrittenJar.getCanonicalPath());
            }
            catch (RuntimeException e2) {
                logger.error("[Transformer] runtimeException occurred while transforming archive: " + e2);
                this.closeQuietly(jarFile);
                this.closeQuietly(archiveFileInputStream);
                this.closeQuietly(byteArrayOutputStream);
                this.closeQuietly(jarInputStream);
                this.closeQuietly(jarOutputStream);
            }
            catch (Exception e3) {
                logger.error("[Transformer] exception occurred while transforming archive: " + e3);
                this.closeQuietly(jarFile);
                this.closeQuietly(archiveFileInputStream);
                this.closeQuietly(byteArrayOutputStream);
                this.closeQuietly(jarInputStream);
                this.closeQuietly(jarOutputStream);
                {
                    catch (Throwable throwable) {
                        this.closeQuietly(jarFile);
                        this.closeQuietly(archiveFileInputStream);
                        this.closeQuietly(byteArrayOutputStream);
                        this.closeQuietly(jarInputStream);
                        this.closeQuietly(jarOutputStream);
                        throw throwable;
                    }
                }
            }
        }
        this.closeQuietly(jarFile);
        this.closeQuietly(archiveFileInputStream);
        this.closeQuietly(byteArrayOutputStream);
        this.closeQuietly(jarInputStream);
        this.closeQuietly(jarOutputStream);
        return didProcessArchive;
    }

    public ClassTransformer withWriteMode(WriteMode writeMode) {
        this.writeMode = writeMode;
        return this;
    }

    private boolean writeClassStream(InputStream inStream, OutputStream outStrm) throws IOException {
        return (this.writeMode == WriteMode.always || this.writeMode == WriteMode.modified && this.classData != null && this.classData.isModified()) && inStream != null && 0 < StreamUtil.copy(inStream, outStrm);
    }

    private boolean writeClassFile(InputStream inStream, File className) {
        boolean writeResult = false;
        if (this.writeMode == WriteMode.always || this.writeMode == WriteMode.modified && this.classData != null && this.classData.isModified()) {
            if (inStream != null && className != null && className.getParentFile() != null) {
                boolean result = className.getParentFile().mkdirs();
                try (FileOutputStream modifiedClassBytesStream = new FileOutputStream(className);){
                    writeResult = this.writeClassStream(inStream, modifiedClassBytesStream);
                    this.closeQuietly(modifiedClassBytesStream);
                }
                catch (IOException e) {
                    logger.error("[Transformer] exception occurred while writing class file: " + e);
                }
            } else {
                logger.error("[Transformer] input stream or class name is missing.");
            }
        }
        return writeResult;
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                logger.warn("[Transformer] exception occurred while closing: " + e);
            }
        }
    }

    public static enum WriteMode {
        modified,
        always;

    }
}

