/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.apms.plugin.instrument.config;

import com.huawei.agconnect.apms.plugin.instrument.annotation.AnnotatedMethodFactory;
import com.huawei.agconnect.apms.plugin.instrument.annotation.TraceAnnotationProcessor;
import com.huawei.agconnect.apms.plugin.instrument.model.ClassMethod;
import com.huawei.agconnect.apms.plugin.instrument.model.LifecycleMethod;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.objectweb.asm.commons.Method;

public class InstrumentationConfig {
    private static final Map<String, String> METHOD_WRAPPER_STRING_MAP = new HashMap<String, String>(){
        {
            this.put("com/squareup/okhttp/OkHttpClient.open(Ljava/net/URL;)Ljava/net/HttpURLConnection;", "com/huawei/agconnect/apms/instrument/OkHttpInstrumentation.open(Ljava/net/HttpURLConnection;)Ljava/net/HttpURLConnection;");
            this.put("com/squareup/okhttp/OkHttpClient.open(Ljava/net/URL;Ljava/net/Proxy)Ljava/net/HttpURLConnection;", "com/huawei/agconnect/apms/instrument/OkHttpInstrumentation.openWithProxy(Ljava/net/HttpURLConnection;)Ljava/net/HttpURLConnection;");
            this.put("com/squareup/okhttp/OkUrlFactory.open(Ljava/net/URL;)Ljava/net/HttpURLConnection;", "com/huawei/agconnect/apms/instrument/OkHttpInstrumentation.urlFactoryOpen(Ljava/net/HttpURLConnection;)Ljava/net/HttpURLConnection;");
            this.put("okhttp3/OkHttpClient.open(Ljava/net/URL;)Ljava/net/HttpURLConnection;", "com/huawei/agconnect/apms/instrument/OkHttp3Instrumentation.open(Ljava/net/HttpURLConnection;)Ljava/net/HttpURLConnection;");
            this.put("okhttp3/OkHttpClient.open(Ljava/net/URL;Ljava/net/Proxy)Ljava/net/HttpURLConnection;", "com/huawei/agconnect/apms/instrument/OkHttp3Instrumentation.openWithProxy(Ljava/net/HttpURLConnection;)Ljava/net/HttpURLConnection;");
            this.put("okhttp3/OkUrlFactory.open(Ljava/net/URL;)Ljava/net/HttpURLConnection;", "com/huawei/agconnect/apms/instrument/OkHttp3Instrumentation.urlFactoryOpen(Ljava/net/HttpURLConnection;)Ljava/net/HttpURLConnection;");
            this.put("java/net/URL.openConnection()Ljava/net/URLConnection;", "com/huawei/agconnect/apms/instrument/URLConnectionInstrumentation.openConnection(Ljava/net/URLConnection;)Ljava/net/URLConnection;");
            this.put("java/net/URL.openConnection(Ljava/net/Proxy;)Ljava/net/URLConnection;", "com/huawei/agconnect/apms/instrument/URLConnectionInstrumentation.openConnectionWithProxy(Ljava/net/URLConnection;)Ljava/net/URLConnection;");
        }
    };
    private static final Map<String, String> CALL_SITE_REPLACEMENT_STRING_MAP = new HashMap<String, String>(){
        {
            this.put("body()Lcom/squareup/okhttp/ResponseBody;", "com/huawei/agconnect/apms/instrument/okhttp2/OkHttp2Instrumentation.body(Lcom/squareup/okhttp/Response;)Lcom/squareup/okhttp/ResponseBody;");
            this.put("body(Lcom/squareup/okhttp/ResponseBody;)Lcom/squareup/okhttp/Response$Builder;", "com/huawei/agconnect/apms/instrument/okhttp2/OkHttp2Instrumentation.body(Lcom/squareup/okhttp/Response$Builder;Lcom/squareup/okhttp/ResponseBody;)Lcom/squareup/okhttp/Response$Builder;");
            this.put("build()Lcom/squareup/okhttp/Request;", "com/huawei/agconnect/apms/instrument/okhttp2/OkHttp2Instrumentation.build(Lcom/squareup/okhttp/Request$Builder;)Lcom/squareup/okhttp/Request;");
            this.put("newBuilder()Lcom/squareup/okhttp/Response$Builder;", "com/huawei/agconnect/apms/instrument/okhttp2/OkHttp2Instrumentation.newBuilder(Lcom/squareup/okhttp/Response$Builder;)Lcom/squareup/okhttp/Response$Builder;");
            this.put("newCall(Lcom/squareup/okhttp/Request;)Lcom/squareup/okhttp/Call;", "com/huawei/agconnect/apms/instrument/okhttp2/OkHttp2Instrumentation.newCall(Lcom/squareup/okhttp/OkHttpClient;Lcom/squareup/okhttp/Request;)Lcom/squareup/okhttp/Call;");
            this.put("com/squareup/okhttp/OkUrlFactory.open(Ljava/net/URL;)Ljava/net/HttpURLConnection;", "com/huawei/agconnect/apms/instrument/okhttp2/OkHttp2Instrumentation.open(Lcom/squareup/okhttp/OkUrlFactory;Ljava/net/URL;)Ljava/net/HttpURLConnection;");
            this.put("build()Lokhttp3/OkHttpClient;", "com/huawei/agconnect/apms/instrument/okhttp3/OkHttp3Instrumentation.build(Lokhttp3/OkHttpClient$Builder;)Lokhttp3/OkHttpClient;");
            this.put("body(Lokhttp3/ResponseBody;)Lokhttp3/Response$Builder;", "com/huawei/agconnect/apms/instrument/okhttp3/OkHttp3Instrumentation.body(Lokhttp3/Response$Builder;Lokhttp3/ResponseBody;)Lokhttp3/Response$Builder;");
            this.put("build()Lokhttp3/Request;", "com/huawei/agconnect/apms/instrument/okhttp3/OkHttp3Instrumentation.build(Lokhttp3/Request$Builder;)Lokhttp3/Request;");
            this.put("newBuilder()Lokhttp3/Response$Builder;", "com/huawei/agconnect/apms/instrument/okhttp3/OkHttp3Instrumentation.newBuilder(Lokhttp3/Response$Builder;)Lokhttp3/Response$Builder;");
            this.put("newCall(Lokhttp3/Request;)Lokhttp3/Call;", "com/huawei/agconnect/apms/instrument/okhttp3/OkHttp3Instrumentation.newCall(Lokhttp3/OkHttpClient;Lokhttp3/Request;)Lokhttp3/Call;");
            this.put("okhttp3/OkUrlFactory.open(Ljava/net/URL;)Ljava/net/HttpURLConnection;", "com/huawei/agconnect/apms/instrument/okhttp3/OkHttp3Instrumentation.open(Lokhttp3/OkUrlFactory;Ljava/net/URL;)Ljava/net/HttpURLConnection;");
            this.put("org/apache/http/client/HttpClient.execute(Lorg/apache/http/client/methods/HttpUriRequest;)Lorg/apache/http/HttpResponse;", "com/huawei/agconnect/apms/instrument/apacheclient/ApacheClientInstrumentation.execute(Lorg/apache/http/client/HttpClient;Lorg/apache/http/client/methods/HttpUriRequest;)Lorg/apache/http/HttpResponse;");
            this.put("org/apache/http/client/HttpClient.execute(Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;)Lorg/apache/http/HttpResponse;", "com/huawei/agconnect/apms/instrument/apacheclient/ApacheClientInstrumentation.execute(Lorg/apache/http/client/HttpClient;Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;)Lorg/apache/http/HttpResponse;");
            this.put("org/apache/http/client/HttpClient.execute(Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/protocol/HttpContext;)Lorg/apache/http/HttpResponse;", "com/huawei/agconnect/apms/instrument/apacheclient/ApacheClientInstrumentation.execute(Lorg/apache/http/client/HttpClient;Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/protocol/HttpContext;)Lorg/apache/http/HttpResponse;");
            this.put("org/apache/http/client/HttpClient.execute(Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;Lorg/apache/http/protocol/HttpContext;)Lorg/apache/http/HttpResponse;", "com/huawei/agconnect/apms/instrument/apacheclient/ApacheClientInstrumentation.execute(Lorg/apache/http/client/HttpClient;Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;Lorg/apache/http/protocol/HttpContext;)Lorg/apache/http/HttpResponse;");
            this.put("org/apache/http/client/HttpClient.execute(Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/client/ResponseHandler;)Ljava/lang/Object;", "com/huawei/agconnect/apms/instrument/apacheclient/ApacheClientInstrumentation.execute(Lorg/apache/http/client/HttpClient;Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/client/ResponseHandler;)Ljava/lang/Object;");
            this.put("org/apache/http/client/HttpClient.execute(Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;Lorg/apache/http/client/ResponseHandler;)Ljava/lang/Object;", "com/huawei/agconnect/apms/instrument/apacheclient/ApacheClientInstrumentation.execute(Lorg/apache/http/client/HttpClient;Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;Lorg/apache/http/client/ResponseHandler;)Ljava/lang/Object;");
            this.put("org/apache/http/client/HttpClient.execute(Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/client/ResponseHandler;Lorg/apache/http/protocol/HttpContext;)Ljava/lang/Object;", "com/huawei/agconnect/apms/instrument/apacheclient/ApacheClientInstrumentation.execute(Lorg/apache/http/client/HttpClient;Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/client/ResponseHandler;Lorg/apache/http/protocol/HttpContext;)Ljava/lang/Object;");
            this.put("org/apache/http/client/HttpClient.execute(Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;Lorg/apache/http/client/ResponseHandler;Lorg/apache/http/protocol/HttpContext;)Ljava/lang/Object;", "com/huawei/agconnect/apms/instrument/apacheclient/ApacheClientInstrumentation.execute(Lorg/apache/http/client/HttpClient;Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;Lorg/apache/http/client/ResponseHandler;Lorg/apache/http/protocol/HttpContext;)Ljava/lang/Object;");
            this.put("android/graphics/BitmapFactory.decodeFile(Ljava/lang/String;)Landroid/graphics/Bitmap;", "com/huawei/agconnect/apms/instrument/BitmapFactoryInstrumentation.decodeFile(Ljava/lang/String;)Landroid/graphics/Bitmap;");
            this.put("android/graphics/BitmapFactory.decodeFile(Ljava/lang/String;Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;", "com/huawei/agconnect/apms/instrument/BitmapFactoryInstrumentation.decodeFile(Ljava/lang/String;Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;");
            this.put("android/graphics/BitmapFactory.decodeResourceStream(Landroid/content/res/Resources;Landroid/util/TypedValue;Ljava/io/InputStream;Landroid/graphics/Rect;Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;", "com/huawei/agconnect/apms/instrument/BitmapFactoryInstrumentation.decodeResourceStream(Landroid/content/res/Resources;Landroid/util/TypedValue;Ljava/io/InputStream;Landroid/graphics/Rect;Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;");
            this.put("android/graphics/BitmapFactory.decodeResource(Landroid/content/res/Resources;ILandroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;", "com/huawei/agconnect/apms/instrument/BitmapFactoryInstrumentation.decodeResource(Landroid/content/res/Resources;ILandroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;");
            this.put("android/graphics/BitmapFactory.decodeResource(Landroid/content/res/Resources;I)Landroid/graphics/Bitmap;", "com/huawei/agconnect/apms/instrument/BitmapFactoryInstrumentation.decodeResource(Landroid/content/res/Resources;I)Landroid/graphics/Bitmap;");
            this.put("android/graphics/BitmapFactory.decodeByteArray([BIILandroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;", "com/huawei/agconnect/apms/instrument/BitmapFactoryInstrumentation.decodeByteArray([BIILandroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;");
            this.put("android/graphics/BitmapFactory.decodeByteArray([BII)Landroid/graphics/Bitmap;", "com/huawei/agconnect/apms/instrument/BitmapFactoryInstrumentation.decodeByteArray([BII)Landroid/graphics/Bitmap;");
            this.put("android/graphics/BitmapFactory.decodeStream(Ljava/io/InputStream;Landroid/graphics/Rect;Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;", "com/huawei/agconnect/apms/instrument/BitmapFactoryInstrumentation.decodeStream(Ljava/io/InputStream;Landroid/graphics/Rect;Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;");
            this.put("android/graphics/BitmapFactory.decodeStream(Ljava/io/InputStream;)Landroid/graphics/Bitmap;", "com/huawei/agconnect/apms/instrument/BitmapFactoryInstrumentation.decodeStream(Ljava/io/InputStream;)Landroid/graphics/Bitmap;");
            this.put("android/graphics/BitmapFactory.decodeFileDescriptor(Ljava/io/FileDescriptor;Landroid/graphics/Rect;Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;", "com/huawei/agconnect/apms/instrument/BitmapFactoryInstrumentation.decodeFileDescriptor(Ljava/io/FileDescriptor;Landroid/graphics/Rect;Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;");
            this.put("android/graphics/BitmapFactory.decodeFileDescriptor(Ljava/io/FileDescriptor;)Landroid/graphics/Bitmap;", "com/huawei/agconnect/apms/instrument/BitmapFactoryInstrumentation.decodeFileDescriptor(Ljava/io/FileDescriptor;)Landroid/graphics/Bitmap;");
            this.put("query(ZLjava/lang/String;[Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Landroid/os/CancellationSignal;)Landroid/database/Cursor;", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.query(Landroid/database/sqlite/SQLiteDatabase;ZLjava/lang/String;[Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Landroid/os/CancellationSignal;)Landroid/database/Cursor;");
            this.put("query(ZLjava/lang/String;[Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Landroid/database/Cursor;", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.query(Landroid/database/sqlite/SQLiteDatabase;ZLjava/lang/String;[Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Landroid/database/Cursor;");
            this.put("query(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Landroid/database/Cursor;", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.query(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Landroid/database/Cursor;");
            this.put("query(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Landroid/database/Cursor;", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.query(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Landroid/database/Cursor;");
            this.put("queryWithFactory(Landroid/database/sqlite/SQLiteDatabase$CursorFactory;ZLjava/lang/String;[Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Landroid/database/Cursor;", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.queryWithFactory(Landroid/database/sqlite/SQLiteDatabase;Landroid/database/sqlite/SQLiteDatabase$CursorFactory;ZLjava/lang/String;[Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Landroid/database/Cursor;");
            this.put("queryWithFactory(Landroid/database/sqlite/SQLiteDatabase$CursorFactory;ZLjava/lang/String;[Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Landroid/os/CancellationSignal;)Landroid/database/Cursor;", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.queryWithFactory(Landroid/database/sqlite/SQLiteDatabase;Landroid/database/sqlite/SQLiteDatabase$CursorFactory;ZLjava/lang/String;[Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Landroid/os/CancellationSignal;)Landroid/database/Cursor;");
            this.put("rawQuery(Ljava/lang/String;[Ljava/lang/String;)Landroid/database/Cursor;", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.rawQuery(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;[Ljava/lang/String;)Landroid/database/Cursor;");
            this.put("rawQuery(Ljava/lang/String;[Ljava/lang/String;Landroid/os/CancellationSignal;)Landroid/database/Cursor;", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.rawQuery(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;[Ljava/lang/String;Landroid/os/CancellationSignal;)Landroid/database/Cursor;");
            this.put("rawQueryWithFactory(Landroid/database/sqlite/SQLiteDatabase$CursorFactory;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;)Landroid/database/Cursor;", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.rawQueryWithFactory(Landroid/database/sqlite/SQLiteDatabase;Landroid/database/sqlite/SQLiteDatabase$CursorFactory;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;)Landroid/database/Cursor;");
            this.put("rawQueryWithFactory(Landroid/database/sqlite/SQLiteDatabase$CursorFactory;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Landroid/os/CancellationSignal;)Landroid/database/Cursor;", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.rawQueryWithFactory(Landroid/database/sqlite/SQLiteDatabase;Landroid/database/sqlite/SQLiteDatabase$CursorFactory;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Landroid/os/CancellationSignal;)Landroid/database/Cursor;");
            this.put("insert(Ljava/lang/String;Ljava/lang/String;Landroid/content/ContentValues;)J", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.insert(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;Ljava/lang/String;Landroid/content/ContentValues;)J");
            this.put("insertOrThrow(Ljava/lang/String;Ljava/lang/String;Landroid/content/ContentValues;)J", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.insertOrThrow(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;Ljava/lang/String;Landroid/content/ContentValues;)J");
            this.put("insertWithOnConflict(Ljava/lang/String;Ljava/lang/String;Landroid/content/ContentValues;I)J", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.insertWithOnConflict(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;Ljava/lang/String;Landroid/content/ContentValues;I)J");
            this.put("replace(Ljava/lang/String;Ljava/lang/String;Landroid/content/ContentValues;)J", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.replace(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;Ljava/lang/String;Landroid/content/ContentValues;)J");
            this.put("replaceOrThrow(Ljava/lang/String;Ljava/lang/String;Landroid/content/ContentValues;)J", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.replaceOrThrow(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;Ljava/lang/String;Landroid/content/ContentValues;)J");
            this.put("delete(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)I", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.delete(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)I");
            this.put("update(Ljava/lang/String;Landroid/content/ContentValues;Ljava/lang/String;[Ljava/lang/String;)I", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.update(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;Landroid/content/ContentValues;Ljava/lang/String;[Ljava/lang/String;)I");
            this.put("updateWithOnConflict(Ljava/lang/String;Landroid/content/ContentValues;Ljava/lang/String;[Ljava/lang/String;I)I", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.updateWithOnConflict(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;Landroid/content/ContentValues;Ljava/lang/String;[Ljava/lang/String;I)I");
            this.put("execSQL(Ljava/lang/String;)V", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.execSQL(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;)V");
            this.put("execSQL(Ljava/lang/String;[Ljava/lang/Object;)V", "com/huawei/agconnect/apms/instrument/SQLiteInstrumentation.execSQL(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;[Ljava/lang/Object;)V");
        }
    };
    private static final Map<String, String> CALL_VOID_REPLACEMENT_STRING_MAP = new HashMap<String, String>(){
        {
            this.put("logReport(Ljava/lang/String;Ljava/lang/String;Ljava/util/LinkedHashMap;)V", "com/huawei/agconnect/apms/instrument/ReportApiInstrumentation.cloudStorageDataReport(Ljava/lang/String;Ljava/lang/String;Ljava/util/LinkedHashMap;)V");
        }
    };
    private static final Map<String, AnnotatedMethodFactory> ANNOTATED_METHOD_FACTORY_MAP = new HashMap<String, AnnotatedMethodFactory>(){
        {
            this.put("Lcom/huawei/agconnect/apms/instrument/AddCustomTrace;", new TraceAnnotationProcessor.Factory());
        }
    };
    private static final Map<Method, LifecycleMethod> ACTIVITY_METHOD_FACTORY_MAP = new HashMap<Method, LifecycleMethod>(){
        {
            this.put(new Method("onCreate", "(Landroid/os/Bundle;)V"), new LifecycleMethod(new Method("startActivityTrace", "(Ljava/lang/String;)V"), new Method("onActivityCreateEnd", "()V")));
            this.put(new Method("onStart", "()V"), new LifecycleMethod(new Method("onActivityStartBegin", "(Ljava/lang/String;)V"), new Method("onActivityStartEnd", "()V")));
            this.put(new Method("onRestart", "()V"), new LifecycleMethod(new Method("onActivityRestartBegin", "(Ljava/lang/String;)V"), new Method("onActivityRestartEnd", "()V")));
            this.put(new Method("onResume", "()V"), new LifecycleMethod(new Method("onActivityResumeBegin", "(Ljava/lang/String;)V"), new Method("onActivityResumeEnd", "()V")));
        }
    };
    private static final Map<Method, LifecycleMethod> APPLICATION_METHOD_FACTORY_MAP = new HashMap<Method, LifecycleMethod>(){
        {
            this.put(new Method("attachBaseContext", "(Landroid/content/Context;)V"), new LifecycleMethod(new Method("attachBaseContextBegin", "(Landroid/content/Context;)V"), new Method("attachBaseContextEnd", "()V")));
            this.put(new Method("onCreate", "()V"), new LifecycleMethod(new Method("applicationCreateBegin", "(Landroid/content/Context;)V"), new Method("applicationCreateEnd", "()V")));
        }
    };
    private static final Map<Method, LifecycleMethod> FRAGMENT_METHOD_FACTORY_MAP = new HashMap<Method, LifecycleMethod>(){
        {
            this.put(new Method("onCreateView", "(Landroid/view/LayoutInflater;Landroid/view/ViewGroup;Landroid/os/Bundle;)Landroid/view/View;"), new LifecycleMethod(new Method("onCreateViewFragmentBegin", "(Ljava/lang/String;Ljava/lang/String;)V"), new Method("onCreateViewFragmentEnd", "(Ljava/lang/String;Ljava/lang/String;)V")));
            this.put(new Method("onStart", "()V"), new LifecycleMethod(new Method("onStartFragmentBegin", "(Ljava/lang/String;Ljava/lang/String;)V"), new Method("onStartFragmentEnd", "(Ljava/lang/String;Ljava/lang/String;)V")));
            this.put(new Method("onResume", "()V"), new LifecycleMethod(new Method("onResumeFragmentBegin", "(Ljava/lang/String;Ljava/lang/String;)V"), new Method("onResumeFragmentEnd", "(Ljava/lang/String;Ljava/lang/String;)V")));
        }
    };
    private final Map<ClassMethod, ClassMethod> methodWrappers = InstrumentationConfig.getMethodWrappers();
    private final Map<String, Collection<ClassMethod>> callSiteReplacements = InstrumentationConfig.getCallSiteReplacements();
    private final Map<String, Collection<ClassMethod>> callVoidReplacements = InstrumentationConfig.getCallVoidReplacements();

    public Map<Method, LifecycleMethod> getApplicationMethodFactoryMap() {
        return APPLICATION_METHOD_FACTORY_MAP;
    }

    public Map<Method, LifecycleMethod> getActivityMethodFactoryMap() {
        return ACTIVITY_METHOD_FACTORY_MAP;
    }

    public Map<Method, LifecycleMethod> getFragmentMethodFactoryMap() {
        return FRAGMENT_METHOD_FACTORY_MAP;
    }

    public AnnotatedMethodFactory getAnnotatedMethodFactory(String classDesc) {
        return ANNOTATED_METHOD_FACTORY_MAP.get(classDesc);
    }

    public ClassMethod getMethodWrapper(ClassMethod method) {
        return this.methodWrappers.get(method);
    }

    public Collection<ClassMethod> getCallSiteReplacements(String className, String methodName, String methodDesc) {
        ArrayList<ClassMethod> methods = new ArrayList<ClassMethod>();
        Collection<ClassMethod> matches = this.callSiteReplacements.get(MessageFormat.format("{0}:{1}", methodName, methodDesc));
        if (matches != null) {
            methods.addAll(matches);
        }
        if ((matches = this.callSiteReplacements.get(MessageFormat.format("{0}.{1}:{2}", className, methodName, methodDesc))) != null) {
            methods.addAll(matches);
        }
        return methods;
    }

    public Collection<ClassMethod> getCallVoidReplacements(String className, String methodName, String methodDesc) {
        ArrayList<ClassMethod> methods = new ArrayList<ClassMethod>();
        Collection<ClassMethod> matches = this.callVoidReplacements.get(MessageFormat.format("{0}:{1}", methodName, methodDesc));
        if (matches != null) {
            methods.addAll(matches);
        }
        if ((matches = this.callVoidReplacements.get(MessageFormat.format("{0}.{1}:{2}", className, methodName, methodDesc))) != null) {
            methods.addAll(matches);
        }
        return methods;
    }

    private static Map<ClassMethod, ClassMethod> getMethodWrappers() {
        HashMap<ClassMethod, ClassMethod> methodWrappers = new HashMap<ClassMethod, ClassMethod>();
        for (Map.Entry<String, String> entry : METHOD_WRAPPER_STRING_MAP.entrySet()) {
            String originalSig = entry.getKey();
            ClassMethod origClassMethod = ClassMethod.getClassMethod(originalSig);
            ClassMethod wrappingMethod = ClassMethod.getClassMethod(entry.getValue());
            methodWrappers.put(origClassMethod, wrappingMethod);
        }
        return methodWrappers;
    }

    private static Map<String, Collection<ClassMethod>> getCallVoidReplacements() {
        return InstrumentationConfig.getReplacements(CALL_VOID_REPLACEMENT_STRING_MAP);
    }

    private static Map<String, Collection<ClassMethod>> getCallSiteReplacements() {
        return InstrumentationConfig.getReplacements(CALL_SITE_REPLACEMENT_STRING_MAP);
    }

    private static Map<String, Collection<ClassMethod>> getReplacements(Map<String, String> callMap) {
        HashMap<String, HashSet<ClassMethod>> temp = new HashMap<String, HashSet<ClassMethod>>();
        for (Map.Entry<String, String> entry : callMap.entrySet()) {
            String originalSig = entry.getKey();
            if (originalSig.contains(".")) {
                ClassMethod origClassMethod = ClassMethod.getClassMethod(originalSig);
                ClassMethod replacement = ClassMethod.getClassMethod(entry.getValue());
                String key = MessageFormat.format("{0}.{1}:{2}", origClassMethod.getClassName(), origClassMethod.getMethodName(), origClassMethod.getMethodDesc());
                HashSet<ClassMethod> replacements = (HashSet<ClassMethod>)temp.get(key);
                if (replacements == null) {
                    replacements = new HashSet<ClassMethod>();
                    temp.put(key, replacements);
                }
                replacements.add(replacement);
                continue;
            }
            int paren = originalSig.indexOf("(");
            String methodName = originalSig.substring(0, paren);
            String methodDesc = originalSig.substring(paren);
            String key2 = MessageFormat.format("{0}:{1}", methodName, methodDesc);
            ClassMethod replacement2 = ClassMethod.getClassMethod(entry.getValue());
            HashSet<ClassMethod> replacements2 = (HashSet<ClassMethod>)temp.get(key2);
            if (replacements2 == null) {
                replacements2 = new HashSet<ClassMethod>();
                temp.put(key2, replacements2);
            }
            replacements2.add(replacement2);
        }
        HashMap<String, Collection<ClassMethod>> callSiteReplacements = new HashMap<String, Collection<ClassMethod>>();
        for (Map.Entry entry2 : temp.entrySet()) {
            callSiteReplacements.put((String)entry2.getKey(), (Collection<ClassMethod>)entry2.getValue());
        }
        return callSiteReplacements;
    }
}

