/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.apms.plugin.instrument.visitor;

import com.huawei.agconnect.apms.plugin.APMSGradlePlugin;
import com.huawei.agconnect.apms.plugin.instrument.InstrumentationContext;
import com.huawei.agconnect.apms.plugin.instrument.annotation.AnnotatedMethodAdapter;
import com.huawei.agconnect.apms.plugin.instrument.annotation.AnnotatedMethodFactory;
import com.huawei.agconnect.apms.plugin.instrument.model.AnnotationInfo;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.logging.Logger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;

public class AnnotationClassVisitor
extends ClassVisitor {
    private final InstrumentationContext context;
    private static final Logger logger = APMSGradlePlugin.getLogger();

    public AnnotationClassVisitor(ClassVisitor cv, InstrumentationContext context) {
        super(458752, cv);
        this.context = context;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String sig, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, sig, exceptions);
        if (this.context.isSkippedMethod(name, desc)) {
            return mv;
        }
        return new AnnotationMethodVisitor(458752, mv, access, name, desc, this.context);
    }

    public void visitEnd() {
        if (this.context.isClassInstrumented()) {
            this.context.addUniqueTag("Lcom/huawei/agconnect/apms/instrument/Instrumented;");
            super.visitAnnotation("Lcom/huawei/agconnect/apms/instrument/Instrumented;", false);
            logger.info(MessageFormat.format("[AnnotationClassVisitor] tagging {0} as instrumented.", this.context.getFriendlyClassName()));
        }
        super.visitEnd();
    }

    private static class APMSAnnotationVisitor
    extends AnnotationVisitor {
        private AnnotationInfo annotationInfo;

        APMSAnnotationVisitor(int api, AnnotationVisitor annotationVisitor, AnnotationInfo annotationInfo) {
            super(api, annotationVisitor);
            this.annotationInfo = annotationInfo;
        }

        public void visit(String name, Object value) {
            this.annotationInfo.values.put(name, value);
            super.visit(name, value);
        }
    }

    private static class AnnotationMethodVisitor
    extends AdviceAdapter {
        private List<AnnotatedMethodAdapter> annotatedMethodAdapters = new ArrayList<AnnotatedMethodAdapter>();
        private InstrumentationContext context;

        AnnotationMethodVisitor(int api, MethodVisitor methodVisitor, int access, String name, String desc, InstrumentationContext context) {
            super(api, methodVisitor, access, name, desc);
            this.context = context;
        }

        public AnnotationVisitor visitAnnotationDefault() {
            AnnotationVisitor annotationVisitor = super.visitAnnotationDefault();
            return new APMSAnnotationVisitor(458752, annotationVisitor, new AnnotationInfo());
        }

        public AnnotationVisitor visitAnnotation(String classDesc, boolean visible) {
            AnnotationVisitor annotationVisitor = super.visitAnnotation(classDesc, visible);
            AnnotationInfo annotationInfo = new AnnotationInfo();
            annotationVisitor = new APMSAnnotationVisitor(458752, annotationVisitor, annotationInfo);
            AnnotatedMethodFactory annotatedMethodFactory = this.context.getAnnotatedMethodFactory(classDesc);
            if (null != annotatedMethodFactory) {
                logger.info(MessageFormat.format("[AnnotationClassVisitor][AddCustomTrace] tagging {0} as add trace.", classDesc));
                this.context.markModified();
                this.annotatedMethodAdapters.add(annotatedMethodFactory.createAnnotatedMethodInstrumentation(this, annotationInfo));
            }
            return annotationVisitor;
        }

        protected void onMethodEnter() {
            super.onMethodEnter();
            for (AnnotatedMethodAdapter annotationInstr : this.annotatedMethodAdapters) {
                annotationInstr.onMethodEnter();
            }
        }

        protected void onMethodExit(int opcode) {
            super.onMethodExit(opcode);
            for (AnnotatedMethodAdapter annotationInstr : this.annotatedMethodAdapters) {
                annotationInstr.onMethodExit();
            }
        }
    }
}

