/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.apms.plugin.instrument;

import com.huawei.agconnect.apms.plugin.APMSGradlePlugin;
import com.huawei.agconnect.apms.plugin.instrument.InstrumentationContext;
import com.huawei.agconnect.apms.plugin.instrument.config.InstrumentationConfig;
import com.huawei.agconnect.apms.plugin.instrument.exception.InstrumentException;
import com.huawei.agconnect.apms.plugin.instrument.model.ClassData;
import com.huawei.agconnect.apms.plugin.instrument.visitor.APMSClassVisitor;
import com.huawei.agconnect.apms.plugin.instrument.visitor.ActivityClassVisitor;
import com.huawei.agconnect.apms.plugin.instrument.visitor.AnnotationClassVisitor;
import com.huawei.agconnect.apms.plugin.instrument.visitor.ApplicationClassVisitor;
import com.huawei.agconnect.apms.plugin.instrument.visitor.BaseClassVisitor;
import com.huawei.agconnect.apms.plugin.instrument.visitor.CallReplacementVisitor;
import com.huawei.agconnect.apms.plugin.instrument.visitor.ContextInitClassVisitor;
import com.huawei.agconnect.apms.plugin.instrument.visitor.FragmentClassVisitor;
import com.huawei.agconnect.apms.plugin.instrument.visitor.WrapMethodClassVisitor;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.gradle.api.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class Instrument {
    public static Set<String> activityList = new HashSet<String>();
    public static Set<String> fragmentList = new HashSet<String>();
    public static String applicationClassName = "";
    private static final Logger logger = APMSGradlePlugin.getLogger();
    private static final String APMS_AGENT_PACKAGE = "com/huawei/agconnect/apms";
    private static final HashSet<String> EXCLUDED_PACKAGES = new HashSet<String>(){
        {
            this.add(Instrument.APMS_AGENT_PACKAGE);
            this.add("com/huawei/agconnect");
            this.add("com/huawei/hms");
            this.add("com/huawei/hianalytics");
            this.add("com/huawei/updatesdk");
            this.add("com/newrelic/agent/android");
            this.add("com/newrelic/mobile");
            this.add("com/newrelic/com");
            this.add("com/google/firebase/perf/network");
            this.add("com/here/sdk/hacwrapper");
            this.add("org/greenrobot/greendao");
        }
    };
    private static final HashSet<String> INCLUDED_PACKAGES = new HashSet<String>(){
        {
            this.add("androidx/appcompat/app/AppCompatActivity");
            this.add("androidx/core/app/ActivityCompat");
            this.add("androidx/fragment/app/");
            this.add("androidx/fragment/app/Fragment");
            this.add("androidx/fragment/app/FragmentActivity");
            this.add("androidx/leanback/app/Fragment");
            this.add("androidx/legacy/app/ActivityCompat");
            this.add("androidx/legacy/app/FragmentCompat");
            this.add("androidx/preference/Fragment");
            this.add("androidx/sqlite/");
            this.add("com/google/gson/");
            this.add("org.json");
            this.add("com/huawei/agconnect/cloud/storage");
        }
    };
    private final InstrumentationConfig config = new InstrumentationConfig();
    private final InstrumentationContext context = new InstrumentationContext(this.config);

    Instrument() {
    }

    ClassData visitClassBytes(byte[] bytes) {
        return this.visitClassBytesWithOptions(bytes, 2);
    }

    private boolean isIncludedPackage(String packageName) {
        String lowercasePackageName = packageName.toLowerCase(Locale.ENGLISH);
        for (String name : INCLUDED_PACKAGES) {
            if (!lowercasePackageName.startsWith(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isExcludedPackage(String packageName) {
        if (this.isIncludedPackage(packageName)) {
            return false;
        }
        String lowercasePackageName = packageName.toLowerCase(Locale.ENGLISH);
        for (String name : EXCLUDED_PACKAGES) {
            if (!lowercasePackageName.startsWith(name)) continue;
            return true;
        }
        return false;
    }

    private ClassData visitClassBytesWithOptions(byte[] bytes, int classWriterFlags) {
        String className = "an unknown class";
        try {
            ClassReader classReader = new ClassReader(bytes);
            ClassWriter classWriter = new ClassWriter(classReader, classWriterFlags);
            this.context.reset();
            classReader.accept((ClassVisitor)new BaseClassVisitor(this.context), 7);
            className = this.context.getClassName();
            if (!this.context.hasTag("Lcom/huawei/agconnect/apms/instrument/Instrumented;")) {
                Object cv = classWriter;
                if (className.startsWith(APMS_AGENT_PACKAGE)) {
                    cv = new APMSClassVisitor((ClassVisitor)cv, this.context);
                } else {
                    if (this.isExcludedPackage(className)) {
                        return null;
                    }
                    cv = new AnnotationClassVisitor((ClassVisitor)cv, this.context);
                    cv = new ApplicationClassVisitor((ClassVisitor)cv, this.context);
                    cv = new ActivityClassVisitor((ClassVisitor)cv, this.context);
                    cv = new FragmentClassVisitor((ClassVisitor)cv, this.context);
                    cv = new CallReplacementVisitor((ClassVisitor)cv, this.context);
                    cv = new WrapMethodClassVisitor((ClassVisitor)cv, this.context);
                }
                cv = new ContextInitClassVisitor((ClassVisitor)cv, this.context);
                try {
                    classReader.accept((ClassVisitor)cv, 12);
                }
                catch (Exception e) {
                    if (classWriterFlags != 1) {
                        logger.debug(String.format(Locale.ENGLISH, "[Instrument] [%s] %s", className, e.getLocalizedMessage()));
                        logger.debug("[Instrument] retry with COMPUTE_MAXS");
                        return this.visitClassBytesWithOptions(bytes, 1);
                    }
                    logger.warn(String.format(Locale.ENGLISH, "[Instrument] [%s], failed: %s", className, e.getLocalizedMessage()));
                    return new ClassData(bytes, false);
                }
                if (this.context.isClassModified() && bytes.length != classWriter.toByteArray().length) {
                    logger.debug(String.format(Locale.ENGLISH, "[Instrument] instrument class %s, before[%d] after[%d].", className, bytes.length, classWriter.toByteArray().length));
                }
            } else {
                logger.debug(MessageFormat.format("[Instrument] class {0} has already been instrumented, skipping it.", this.context.getFriendlyClassName()));
            }
            return this.context.newClassData(classWriter.toByteArray());
        }
        catch (InstrumentException e2) {
            logger.debug(String.format(Locale.ENGLISH, "[Instrument] %s", e2.getLocalizedMessage()));
            return new ClassData(bytes, false);
        }
        catch (Throwable t) {
            logger.warn(String.format(Locale.ENGLISH, "[Instrument] an error occurred while instrumenting %s, skipping it: %s", className, t.getMessage()));
            return new ClassData(bytes, false);
        }
    }
}

