/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.agcp;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ConfigFileLocation {
    private static final Pattern VARIANT_PATTERN = Pattern.compile("(?:([^\\p{javaUpperCase}]*)((?:\\p{javaUpperCase}[^\\p{javaUpperCase}]*)*)\\/)?([^\\/]*)");
    private static final Pattern FLAVOR_PATTERN = Pattern.compile("(\\p{javaUpperCase}[^\\p{javaUpperCase}]*)");

    static List<String> getLocations(String variantDirname) {
        Matcher variantMatcher = VARIANT_PATTERN.matcher(variantDirname);
        List<String> fileLocations = new ArrayList<String>();
        if (!variantMatcher.matches()) {
            return fileLocations;
        }
        ArrayList<String> flavorNames = new ArrayList<String>();
        if (variantMatcher.group(1) != null) {
            flavorNames.add(variantMatcher.group(1).toLowerCase(Locale.ENGLISH));
        }
        flavorNames.addAll(ConfigFileLocation.splitVariantNames(variantMatcher.group(2)));
        String buildType = variantMatcher.group(3);
        String flavorName = variantMatcher.group(1) + variantMatcher.group(2);
        fileLocations.add("src/" + flavorName + "/" + buildType);
        fileLocations.add("src/" + buildType + "/" + flavorName);
        fileLocations.add("src/" + flavorName);
        fileLocations.add("src/" + buildType);
        fileLocations.add("src/" + flavorName + ConfigFileLocation.capitalize(buildType));
        fileLocations.add("src/" + buildType);
        String fileLocation = "src";
        for (String flavor : flavorNames) {
            fileLocation = fileLocation + "/" + flavor;
            fileLocations.add(fileLocation);
            fileLocations.add(fileLocation + "/" + buildType);
            fileLocations.add(fileLocation + ConfigFileLocation.capitalize(buildType));
        }
        fileLocations = fileLocations.stream().distinct().sorted(Comparator.comparing(ConfigFileLocation::countSlashes)).collect(Collectors.toList());
        return fileLocations;
    }

    private static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        return s.substring(0, 1).toUpperCase(Locale.ENGLISH) + s.substring(1).toLowerCase(Locale.ENGLISH);
    }

    private static long countSlashes(String input) {
        return input.codePoints().filter(string -> string == 47).count();
    }

    private static List<String> splitVariantNames(String variant) {
        if (variant == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> flavors = new ArrayList<String>();
        Matcher flavorMatcher = FLAVOR_PATTERN.matcher(variant);
        while (flavorMatcher.find()) {
            String match = flavorMatcher.group(1);
            if (match == null) continue;
            flavors.add(match.toLowerCase(Locale.ENGLISH));
        }
        return flavors;
    }
}

