/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.agcp;

import com.android.builder.internal.ClassFieldImpl;
import com.android.builder.model.ClassField;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.huawei.agconnect.config.impl.Hex;
import com.huawei.agconnect.config.impl.SHA;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.gradle.api.logging.Logging;

class ConfigParser {
    private static final String RES_NAME_PREFIX = "agc_";
    private static final String RES_TYPE_STRING = "string";
    private static final char PATH_SEPARATOR = '/';
    private final Map<String, ClassField> mValues = Maps.newHashMap();
    private final Map<String, String> mappingValues = Maps.newHashMap();
    private JsonElement rootJsonElement;

    ConfigParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse(File config) throws FileNotFoundException, UnsupportedEncodingException, NoSuchAlgorithmException, JsonParseException {
        this.mValues.clear();
        this.mappingValues.clear();
        InputStreamReader reader = null;
        try {
            JsonElement root;
            reader = new InputStreamReader((InputStream)new FileInputStream(config), "UTF-8");
            this.rootJsonElement = root = new JsonParser().parse((Reader)reader);
            this.toResValues(root, "");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    JsonElement getRootJsonElement() {
        return this.rootJsonElement;
    }

    Map<String, ClassField> getValues() {
        return this.mValues;
    }

    Map<String, String> getMappingValues() {
        return this.mappingValues;
    }

    String getValue(String path) {
        String name;
        try {
            name = ConfigParser.toName(path);
        }
        catch (Exception e) {
            return "";
        }
        ClassField value = this.mValues.get(name);
        if (value != null) {
            return value.getValue();
        }
        return "";
    }

    private void toResValues(JsonElement element, String path) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        if (element.isJsonObject()) {
            JsonObject jsonObj = element.getAsJsonObject();
            for (Map.Entry entry : jsonObj.entrySet()) {
                this.toResValues((JsonElement)entry.getValue(), path + '/' + (String)entry.getKey());
            }
        } else {
            String name = ConfigParser.toName(path);
            String value = ConfigParser.toValue(element);
            Logging.getLogger(this.getClass()).info("--I- " + name + "(" + path + ") = " + value);
            this.mValues.put(name, (ClassField)new ClassFieldImpl(RES_TYPE_STRING, name, value));
            this.mappingValues.put(path, value);
        }
    }

    static String toName(String path) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return RES_NAME_PREFIX + Hex.encodeHexString(SHA.sha256(path.getBytes("UTF-8")));
    }

    private static String toValue(JsonElement element) {
        try {
            return element.getAsString();
        }
        catch (Exception e) {
            return element.toString();
        }
    }
}

