/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.agcp;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Hex {
    private static final char[] HEX_CODE = "0123456789ABCDEF".toCharArray();

    public static String encodeHexString(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (byte oneByte : data) {
            sb.append(HEX_CODE[oneByte >> 4 & 0xF]);
            sb.append(HEX_CODE[oneByte & 0xF]);
        }
        return sb.toString();
    }

    public static byte[] decodeHexString(String data) {
        return Hex.decodeHex(data.toCharArray());
    }

    private static byte[] decodeHex(char[] data) {
        if ((data.length & 1) != 0) {
            throw new IllegalArgumentException("Odd number of characters.");
        }
        byte[] out = new byte[data.length >> 1];
        int indexI = 0;
        int indexJ = 0;
        while (indexJ < data.length) {
            int low;
            int high = Character.digit(data[indexJ], 16);
            if (high == -1) {
                throw new IllegalArgumentException("Illegal hexadecimal character at index " + indexJ);
            }
            if ((low = Character.digit(data[++indexJ], 16)) == -1) {
                throw new IllegalArgumentException("Illegal hexadecimal character at index " + indexJ);
            }
            ++indexJ;
            out[indexI] = (byte)((high << 4 | low) & 0xFF);
            ++indexI;
        }
        return out;
    }

    public static byte[] sha256(byte[] data) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("SHA-256").digest(data);
    }
}

