/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.agcp;

import com.android.builder.internal.ClassFieldImpl;
import com.android.builder.model.ClassField;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.huawei.agconnect.agcp.Hex;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.gradle.api.logging.Logging;

class ConfigParser {
    private static final String RES_TYPE_STRING = "string";
    private static final char PATH_SEPARATOR = '/';
    private final Map<String, ClassField> mValues = Maps.newHashMap();
    private final Map<String, String> mappingValues = Maps.newHashMap();
    private JsonElement rootJsonElement;

    ConfigParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse(File config, String pkgName) throws FileNotFoundException, NoSuchAlgorithmException, JsonParseException {
        this.mValues.clear();
        this.mappingValues.clear();
        InputStreamReader reader = null;
        try {
            JsonElement root;
            reader = new InputStreamReader((InputStream)new FileInputStream(config), StandardCharsets.UTF_8);
            this.rootJsonElement = root = new JsonParser().parse((Reader)reader);
            this.replacePkgNameAndAppId(pkgName);
            this.toResValues(root, "");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    void replacePkgNameAndAppId(String pkgName) {
        JsonObject root = this.rootJsonElement.getAsJsonObject();
        JsonArray appInfoArray = root.getAsJsonArray("appInfos");
        if (appInfoArray == null || appInfoArray.size() <= 0) {
            return;
        }
        JsonObject appInfo = this.getObject(appInfoArray, pkgName);
        if (appInfo == null) {
            return;
        }
        String configurationVersion = this.getAsString(root, "configuration_version");
        BigDecimal version = new BigDecimal("0.0");
        try {
            version = BigDecimal.valueOf(Double.parseDouble(configurationVersion));
        }
        catch (NumberFormatException e) {
            Logging.getLogger(this.getClass()).warn(String.format(Locale.ENGLISH, "--W- parse configuration_version[%s] error", configurationVersion));
        }
        if (version.compareTo(new BigDecimal("2.0")) == 0) {
            JsonObject clientObj;
            String appId = this.getAsString(appInfo, "app_id");
            if (!"".equals(appId) && (clientObj = root.getAsJsonObject("client")) != null) {
                clientObj.addProperty("app_id", appId);
                clientObj.addProperty("package_name", pkgName);
            }
        } else if (version.compareTo(new BigDecimal("3.0")) >= 0) {
            for (Map.Entry entry : appInfo.entrySet()) {
                if ("package_name".equals(entry.getKey())) {
                    JsonObject clientObj = root.getAsJsonObject("client");
                    if (clientObj == null) continue;
                    clientObj.addProperty("package_name", pkgName);
                    continue;
                }
                this.replace((String)entry.getKey(), (JsonElement)entry.getValue(), (JsonElement)root);
            }
        }
    }

    private void replace(String key, JsonElement value, JsonElement replace) {
        if (value == null || replace == null) {
            return;
        }
        if (value.isJsonObject()) {
            for (Map.Entry entry : value.getAsJsonObject().entrySet()) {
                this.replace((String)entry.getKey(), (JsonElement)entry.getValue(), replace.getAsJsonObject().get(key));
            }
        } else if (value.isJsonPrimitive()) {
            replace.getAsJsonObject().add(key, value);
        }
    }

    private JsonObject getObject(JsonArray appInfoArray, String pkgName) {
        for (int i = 0; i < appInfoArray.size(); ++i) {
            JsonObject appInfo = appInfoArray.get(i).getAsJsonObject();
            String packageName = this.getAsString(appInfo, "package_name");
            if (!packageName.equals(pkgName)) continue;
            return appInfo;
        }
        return null;
    }

    JsonElement getRootJsonElement() {
        return this.rootJsonElement;
    }

    Map<String, ClassField> getValues() {
        return this.mValues;
    }

    Map<String, String> getMappingValues() {
        return this.mappingValues;
    }

    String getValue(String path) {
        String name;
        try {
            name = ConfigParser.toName(path);
        }
        catch (Exception e) {
            return "";
        }
        ClassField value = this.mValues.get(name);
        if (value != null) {
            return value.getValue();
        }
        return "";
    }

    private void toResValues(JsonElement element, String path) throws NoSuchAlgorithmException {
        if (element.isJsonObject()) {
            JsonObject jsonObj = element.getAsJsonObject();
            for (Map.Entry entry : jsonObj.entrySet()) {
                this.toResValues((JsonElement)entry.getValue(), path + '/' + (String)entry.getKey());
            }
        } else {
            String name = ConfigParser.toName(path);
            String value = ConfigParser.toValue(element);
            Logging.getLogger(this.getClass()).info("--I- " + name + "(" + path + ") = " + value);
            this.mValues.put(name, (ClassField)new ClassFieldImpl(RES_TYPE_STRING, name, value));
            this.mappingValues.put(path, value);
        }
    }

    private String getAsString(JsonObject jsonObject, String key) {
        JsonElement element;
        if (jsonObject != null && (element = jsonObject.get(key)) != null) {
            return element.getAsString();
        }
        return "";
    }

    static String toName(String path) throws NoSuchAlgorithmException {
        return Hex.encodeHexString(Hex.sha256(path.getBytes(StandardCharsets.UTF_8)));
    }

    private static String toValue(JsonElement element) {
        try {
            return element.getAsString();
        }
        catch (Exception e) {
            return element.toString();
        }
    }
}

