/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.agconnect.crash.symbol.lib.https;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.huawei.agconnect.crash.symbol.lib.https.FileRequest;
import com.huawei.agconnect.crash.symbol.lib.https.Request;
import com.huawei.agconnect.crash.symbol.lib.log.AGCLogger;
import com.huawei.agconnect.crash.symbol.lib.utils.a;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class Backend {
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String CONTENT_FORM_DATA_BOUNDARY = "multipart/form-data;boundary=";
    private static final int CONNECT_TIMEOUT = 10000;
    private static final String FILE_LARGE_ERROR = "Uploading failed because the file is too large, please upload it manually on the AGC website or contact the webmaster";
    public static final String END = "\r\n";
    public static final String TWOHYPHENS = "--";

    public static <T> T postJson(Request request, Class<T> clazz) {
        return Backend.postJsonByUrlConnection(request, clazz, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T postJsonByUrlConnection(Request request, Class<T> clazz, int n2) {
        Object object = request.getUrls().get(n2);
        DataOutputStream dataOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            int n3;
            object = (HttpURLConnection)new URL((String)object).openConnection();
            ((HttpURLConnection)object).setRequestMethod("POST");
            ((URLConnection)object).setConnectTimeout(8000);
            ((URLConnection)object).setReadTimeout(8000);
            ((URLConnection)object).setDoOutput(true);
            ((URLConnection)object).setDoInput(true);
            ((URLConnection)object).setUseCaches(false);
            ((HttpURLConnection)object).setInstanceFollowRedirects(true);
            ((URLConnection)object).setRequestProperty("Content-Type", CONTENT_TYPE_JSON);
            for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                ((URLConnection)object).setRequestProperty(entry.getKey(), entry.getValue());
            }
            Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
            String string = gson.toJson((Object)request);
            dataOutputStream = new DataOutputStream(((URLConnection)object).getOutputStream());
            dataOutputStream.writeBytes(string);
            dataOutputStream.flush();
            int n4 = ((HttpURLConnection)object).getResponseCode();
            bufferedInputStream = n4 == 200 ? new BufferedInputStream(((URLConnection)object).getInputStream()) : new BufferedInputStream(((HttpURLConnection)object).getErrorStream());
            object = new byte[1024];
            a a2 = new a();
            while ((n3 = bufferedInputStream.read((byte[])object)) != -1) {
                a2.a((byte[])object, n3);
            }
            object = a2.a();
            if (n4 == 200) {
                object = new Gson().fromJson((String)object, clazz);
                Backend.closeIO(dataOutputStream);
                Backend.closeIO(bufferedInputStream);
                return (T)object;
            }
            AGCLogger.error(String.format(Locale.ENGLISH, "ERROR:HTTP Exception, code:%s, response:%s", n4, object));
            Backend.closeIO(dataOutputStream);
        }
        catch (IOException iOException) {
            block10: {
                object = iOException;
                if (!(iOException instanceof UnknownHostException) || request.getUrls().size() <= n2 + 1) break block10;
                T t = Backend.postJsonByUrlConnection(request, clazz, ++n2);
                return t;
            }
            AGCLogger.error("ERROR:HTTP Exception, " + ((Throwable)object).getMessage());
            return null;
        }
        finally {
            Backend.closeIO(dataOutputStream);
            Backend.closeIO(bufferedInputStream);
        }
        Backend.closeIO(bufferedInputStream);
        return null;
    }

    public static <T> T postFile(FileRequest fileRequest, Class<T> clazz) {
        File file = fileRequest.getFile();
        if (file == null || !file.exists()) {
            return null;
        }
        return Backend.postFileByHttpUrlConnection(fileRequest, clazz, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T postFileByHttpUrlConnection(FileRequest fileRequest, Class<T> clazz, int n2) {
        Object object;
        a a2 = new a();
        Object object2 = fileRequest.getUrls().get(n2);
        DataOutputStream dataOutputStream = null;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            int n3;
            int n4;
            object2 = (HttpURLConnection)new URL((String)object2).openConnection();
            ((URLConnection)object2).setConnectTimeout(10000);
            ((URLConnection)object2).setDoOutput(true);
            ((URLConnection)object2).setDoInput(true);
            ((URLConnection)object2).setUseCaches(false);
            ((HttpURLConnection)object2).setRequestMethod("POST");
            for (Map.Entry entry : fileRequest.getHeaders().entrySet()) {
                AGCLogger.info("addHeader:" + (String)entry.getKey() + "=" + (String)entry.getValue());
                ((URLConnection)object2).addRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            object = UUID.randomUUID().toString();
            ((URLConnection)object2).addRequestProperty("Content-Type", CONTENT_FORM_DATA_BOUNDARY + (String)object);
            ((URLConnection)object2).connect();
            dataOutputStream = new DataOutputStream(((URLConnection)object2).getOutputStream());
            File file = fileRequest.getFile();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(TWOHYPHENS + (String)object + END);
            stringBuilder.append("Content-Disposition: form-data;name=\"file\"; filename=\"" + file.getName() + "\"\r\n");
            stringBuilder.append("Content-Type: application/octet-stream\r\n");
            stringBuilder.append("Content-Transfer-Encoding: binary\r\n\r\n");
            dataOutputStream.writeBytes(stringBuilder.toString());
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[1024];
            while ((n4 = fileInputStream.read(byArray)) != -1) {
                dataOutputStream.write(byArray, 0, n4);
            }
            dataOutputStream.writeBytes(END);
            Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
            String string = gson.toJson((Object)fileRequest);
            Object object32 = new JsonParser();
            JsonElement jsonElement = object32.parse(string);
            if (jsonElement.isJsonObject()) {
                Set set = jsonElement.getAsJsonObject().entrySet();
                for (Object object32 : set) {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    stringBuilder2.append(TWOHYPHENS + (String)object + END);
                    stringBuilder2.append("Content-Disposition: form-data; name=\"" + (String)object32.getKey() + "\"\r\n");
                    stringBuilder2.append("Content-Type: text/plain; charset=US-ASCII\r\n");
                    stringBuilder2.append("Content-Transfer-Encoding: 8bit\r\n\r\n");
                    dataOutputStream.write(stringBuilder2.toString().getBytes());
                    dataOutputStream.writeBytes(((JsonElement)object32.getValue()).getAsString());
                    dataOutputStream.writeBytes(END);
                }
            }
            object32 = new StringBuilder();
            ((StringBuilder)object32).append(TWOHYPHENS + (String)object + "--\r\n");
            dataOutputStream.writeBytes(((StringBuilder)object32).toString());
            dataOutputStream.flush();
            int n5 = ((HttpURLConnection)object2).getResponseCode();
            bufferedInputStream = n5 == 200 ? new BufferedInputStream(((URLConnection)object2).getInputStream()) : new BufferedInputStream(((HttpURLConnection)object2).getErrorStream());
            Object object4 = new byte[1024];
            while ((n3 = ((InputStream)bufferedInputStream).read((byte[])object4)) != -1) {
                a2.a((byte[])object4, n3);
            }
            String string2 = a2.a();
            if (n5 == 200) {
                Object object5 = new Gson().fromJson(string2, clazz);
                Backend.closeIO(dataOutputStream);
                Backend.closeIO(fileInputStream);
                Backend.closeIO(bufferedInputStream);
                return (T)object5;
            }
            if (n5 == 413) {
                AGCLogger.error(String.format(Locale.ENGLISH, "ERROR:HTTP Exception, code:%s, response:%s", n5, FILE_LARGE_ERROR));
            } else {
                AGCLogger.error(String.format(Locale.ENGLISH, "ERROR:HTTP Exception, code:%s, response:%s", n5, string2));
            }
            Backend.closeIO(dataOutputStream);
        }
        catch (IOException iOException) {
            block15: {
                object2 = iOException;
                if (!(iOException instanceof UnknownHostException) || fileRequest.getUrls().size() <= n2 + 1) break block15;
                object = Backend.postFileByHttpUrlConnection(fileRequest, clazz, ++n2);
                return (T)object;
            }
            AGCLogger.error("ERROR:HTTP Exception, " + ((Throwable)object2).getMessage());
            return null;
        }
        finally {
            Backend.closeIO(dataOutputStream);
            Backend.closeIO(fileInputStream);
            Backend.closeIO(bufferedInputStream);
        }
        Backend.closeIO(fileInputStream);
        Backend.closeIO(bufferedInputStream);
        return null;
    }

    private static void closeIO(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (IOException iOException) {
                AGCLogger.error("close io error:" + iOException.getMessage());
            }
        }
    }
}

